package com.namasoft.contracts.common.dtos;

import com.namasoft.common.*;
import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.edit.*;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

@SuppressWarnings("serial")
public class GUIActionResult implements Serializable
{
	private FlatObject flatObject;
	@GwtTransient
	private Object realObject;
	private ListOfGenericValues updateList = new ListOfGenericValues();
	private GUIActionResultType type;
	private AfterPerformBehavior afterPerformBehavior;
	private List<NaMaText> messages;
	private List<NaMaError> errors;
	private String internalURL;
	private String externalURL;
	private String textToCopy;
	private Boolean inNewWindow;
	private Boolean inPopup;
	private Boolean inBrowserPopUpWindow;
	private String tabId;
	private String pendingResponseId;
	private BigDecimal progressCurrent;
	private BigDecimal progressTotal;
	private NaMaText progressTitle;
	private Boolean processing;
	private ServiceRequest contextRequest;
	private Date submittedOn;
	private GCFailure failure;
	private String iconCode;
	private String iconConstant;

	public GUIActionResult()
	{
		super();
	}

	private EditScreenList popupListView;
	private boolean messageIsError = false;
	private PrintBarcodeData printBarCode;
	private String place;

	public FlatObject getFlatObject()
	{
		return flatObject;
	}

	public void setFlatObject(FlatObject flatObject)
	{
		this.flatObject = flatObject;
	}

	public ListOfGenericValues getUpdateList()
	{
		return updateList;
	}

	public void setUpdateList(ListOfGenericValues updateList)
	{
		this.updateList = updateList;
	}

	public GUIActionResultType getType()
	{
		return type;
	}

	public void setType(GUIActionResultType type)
	{
		this.type = type;
	}

	public List<NaMaText> getMessages()
	{
		return messages;
	}

	public void setMessages(List<NaMaText> msg)
	{
		this.messages = msg;
	}

	public List<NaMaError> getErrors()
	{
		return errors;
	}

	public void setErrors(List<NaMaError> errors)
	{
		this.errors = errors;
	}

	public AfterPerformBehavior getAfterPerformBehavior()
	{
		return afterPerformBehavior;
	}

	public void setAfterPerformBehavior(AfterPerformBehavior afterPerformBehavior)
	{
		this.afterPerformBehavior = afterPerformBehavior;
	}

	public String getInternalURL()
	{
		return internalURL;
	}

	public void setInternalURL(String url)
	{
		this.internalURL = url;
	}

	public String getExternalURL()
	{
		return externalURL;
	}

	public void setExternalURL(String externalURL)
	{
		this.externalURL = externalURL;
	}

	public boolean isMessageIsError()
	{
		return messageIsError;
	}

	public void setMessageIsError(boolean messageIsError)
	{
		this.messageIsError = messageIsError;
	}

	public GUIActionResult addUpdatedValues(String fieldId, Object value)
	{
		setType(GUIActionResultType.UpdateList);
		getUpdateList().addValue(fieldId, value);
		return this;
	}

	public GUIActionResult addUpdatedValuesAtRow(String fieldId, Object value, Integer atRow)
	{
		setType(GUIActionResultType.UpdateList);
		GenericValue v = new GenericValue(fieldId, value);
		v.setAtRow(atRow);
		getUpdateList().addValue(v);
		return this;
	}

	public void popupListView(EditScreenList popupListView)
	{
		setType(GUIActionResultType.PopupListView);
		setListView(popupListView);
	}

	public void printBarcode(PrintBarcodeData barcodeData)
	{
		setType(GUIActionResultType.BarcodePrint);
		setPrintBarCode(barcodeData);
	}

	public static GUIActionResult success()
	{
		return new GUIActionResult().success(NaMaText.resource("operationSuccessfull"));
	}

	public GUIActionResult success(NaMaText msg)
	{
		setMessages(new ArrayList<NaMaText>(Arrays.asList(msg)));
		setMessageIsError(false);
		return this;
	}

	public GUIActionResult failure(NaMaText msg)
	{
		setMessages(new ArrayList<NaMaText>(Arrays.asList(msg)));
		setMessageIsError(true);
		return this;
	}

	public GUIActionResult failure(ResultDTO result)
	{
		setMessageIsError(true);
		List<NaMaError> errors = NaMaError.createErrorsForLeafResults(result);
		if (getMessages() == null)
			setMessages(new ArrayList<>());
		if (getErrors() == null)
			setErrors(new ArrayList<>());
		getErrors().addAll(errors);
		return failure(errors);
	}

	public GUIActionResult updateList(ListOfGenericValues updateList)
	{
		setUpdateList(updateList);
		setType(GUIActionResultType.UpdateList);
		return this;
	}

	public GUIActionResult tabId(String tabId)
	{
		setTabId(tabId);
		return this;
	}
	public GUIActionResult newRecord(FlatObject flatObject)
	{
		setFlatObject(flatObject);
		setType(GUIActionResultType.NewRecord);
		return this;
	}

	public GUIActionResult newRecordInPopup(FlatObject flatObject)
	{
		setFlatObject(flatObject);
		setType(GUIActionResultType.NewRecordInPopup);
		return this;
	}

	public GUIActionResult internalOrExternalUrl(String url)
	{
		url = removePrefixesAndSetOptions(url);
		String lowerCaseURL = url.trim().toLowerCase();
		if (lowerCaseURL.startsWith("http://") || lowerCaseURL.startsWith("https://"))
			externalUrl(url);
		else if (lowerCaseURL.startsWith("external:"))
			externalUrl(url.substring("external".length()));
		else
			internalUrl(url);
		return this;
	}

	public GUIActionResult internalUrl(String url)
	{
		url = removePrefixesAndSetOptions(url);
		setInternalURL(url);
		setType(GUIActionResultType.InternalURL);

		return this;
	}

	private String removePrefixesAndSetOptions(String url)
	{
		url = url.trim();
		if (url.startsWith(CommonConstants.OPEN_LINK_IN_NEW_WINDOW))
		{
			url = url.substring(CommonConstants.OPEN_LINK_IN_NEW_WINDOW.length());
			setInNewWindow(true);
		}
		else if (url.startsWith(CommonConstants.OPEN_LINK_IN_POPUP))
		{
			url = url.substring(CommonConstants.OPEN_LINK_IN_POPUP.length());
			setInPopup(true);
		}
		else if (url.startsWith(CommonConstants.OPEN_LINK_IN_BROWSER_POPUP_WINDOW))
		{
			url = url.substring(CommonConstants.OPEN_LINK_IN_BROWSER_POPUP_WINDOW.length());
			setInBrowserPopUpWindow(true);
		}
		return url;
	}

	public GUIActionResult place(String place)
	{
		if (place.startsWith("#"))
			place = place.substring(1);
		setPlace(place);
		setType(GUIActionResultType.GoToPlace);
		return this;
	}

	public GUIActionResult externalUrl(String url)
	{
		setExternalURL(url);
		setType(GUIActionResultType.ExternalURL);
		return this;
	}

	public GUIActionResult refresh()
	{
		setAfterPerformBehavior(AfterPerformBehavior.Refresh);
		return this;
	}

	public static GUIActionResult create()
	{
		return new GUIActionResult();
	}

	public static GUIActionResult pleaseSelectRows()
	{
		return create().failure(NaMaText.resource("pleaseSelectRows"));
	}

	public static GUIActionResult pleaseConfirm()
	{
		return create().failure(NaMaText.resource("pleaseConfirm"));
	}

	public static GUIActionResult mustSelectJustOneRow()
	{
		return create().failure(NaMaText.resource("mustSelectJustOneRow"));
	}

	public EditScreenList getListView()
	{
		return popupListView;
	}

	public void setListView(EditScreenList popupListView)
	{
		this.popupListView = popupListView;
	}

	public static GUIActionResult failure(List<NaMaError> errors)
	{
		GUIActionResult result = create();
		result.setMessageIsError(true);
		result.setErrors(errors);
		return result;
	}

	public PrintBarcodeData getPrintBarCode()
	{
		return printBarCode;
	}

	public void setPrintBarCode(PrintBarcodeData printBarCode)
	{
		this.printBarCode = printBarCode;
	}

	public EditScreenList getPopupListView()
	{
		return popupListView;
	}

	public void setPopupListView(EditScreenList popupListView)
	{
		this.popupListView = popupListView;
	}

	public String getPlace()
	{
		return place;
	}

	public void setPlace(String place)
	{
		this.place = place;
	}

	public GUIActionResult textToCopy(String text)
	{
		setType(GUIActionResultType.TextToCopy);
		setTextToCopy(text);
		return this;
	}

	public void setTextToCopy(String textToCopy)
	{
		this.textToCopy = textToCopy;
	}

	public String getTextToCopy()
	{
		return textToCopy;
	}

	public void setInNewWindow(Boolean inNewWindow)
	{
		this.inNewWindow = inNewWindow;
	}

	public Boolean getInNewWindow()
	{
		return inNewWindow;
	}

	public Boolean getInPopup()
	{
		return inPopup;
	}

	public void setInPopup(Boolean inPopup)
	{
		this.inPopup = inPopup;
	}

	public Boolean getInBrowserPopUpWindow()
	{
		return inBrowserPopUpWindow;
	}

	public void setInBrowserPopUpWindow(Boolean inBrowserPopUpWindow)
	{
		this.inBrowserPopUpWindow = inBrowserPopUpWindow;
	}

	public Object getRealObject()
	{
		return realObject;
	}

	public void setRealObject(Object realObject)
	{
		this.realObject = realObject;
	}

	public String getTabId()
	{
		return tabId;
	}

	public void setTabId(String tabId)
	{
		this.tabId = tabId;
	}

	public String getPendingResponseId()
	{
		return pendingResponseId;
	}

	public void setPendingResponseId(String pendingResponseId)
	{
		this.pendingResponseId = pendingResponseId;
	}

	public void mergeWith(GUIActionResult result)
	{
		if (ObjectChecker.isFalse(messageIsError))
			messageIsError = result.messageIsError;
		if (result.getMessages() != null)
		{
			if (getMessages() == null)
				setMessages(new ArrayList<>());
			getMessages().addAll(result.getMessages());
		}
		if (result.getErrors() != null)
		{
			if (getErrors() == null)
				setErrors(new ArrayList<>());
			getErrors().addAll(result.getErrors());
		}

		if (result.getUpdateList() != null)
			getUpdateList().addAll(result.getUpdateList().getDetails());
		if (ObjectChecker.isNotEmptyOrNull(result.getInternalURL()))
		{
			if (ObjectChecker.isNotEmptyOrNull(getInternalURL()))
				setInternalURL(getInternalURL() + CommonConstants.URLS_SEPERATOR);
			setInternalURL(ObjectChecker.toStringOrEmpty(getInternalURL()) + result.getInternalURL());
			setType(GUIActionResultType.InternalURL);
		}
		if (result.getType() == GUIActionResultType.TextToCopy)
		{
			setType(GUIActionResultType.TextToCopy);
			setTextToCopy(result.getTextToCopy());
		}
	}

	public boolean failed()
	{
		return ObjectChecker.isTrue(messageIsError);
	}

	public GUIActionResult addUpdatedValues(List<GenericValue> values)
	{
		setType(GUIActionResultType.UpdateList);
		getUpdateList().addAll(values);
		return this;
	}

	public GUIActionResult replaceCurrentRecord(FlatObject object)
	{
		return GUIActionResult.create().addUpdatedValues(CommonConstants.REPLACE_RECORD, object);
	}

	public BigDecimal getProgressCurrent()
	{
		return progressCurrent;
	}

	public void setProgressCurrent(BigDecimal progressCurrent)
	{
		this.progressCurrent = progressCurrent;
	}

	public BigDecimal getProgressTotal()
	{
		return progressTotal;
	}

	public void setProgressTotal(BigDecimal progressTotal)
	{
		this.progressTotal = progressTotal;
	}

	public NaMaText getProgressTitle()
	{
		return progressTitle;
	}

	public void setProgressTitle(NaMaText progressTitle)
	{
		this.progressTitle = progressTitle;
	}

	public Boolean getProcessing()
	{
		return processing;
	}

	public void setProcessing(Boolean processing)
	{
		this.processing = processing;
	}

	public ServiceRequest getContextRequest()
	{
		return contextRequest;
	}

	public void setContextRequest(ServiceRequest contextRequest)
	{
		this.contextRequest = contextRequest;
	}

	public Date getSubmittedOn()
	{
		return submittedOn;
	}

	public void setSubmittedOn(Date submittedOn)
	{
		this.submittedOn = submittedOn;
	}

	public void setFailure(GCFailure failure)
	{
		this.failure = failure;
	}

	public GCFailure getFailure()
	{
		return failure;
	}

	public void failed(GCFailure gcFailure)
	{
		setFailure(gcFailure);
		setProcessing(false);
	}

	public String getIconCode()
	{
		return iconCode;
	}

	public void setIconCode(String iconCode)
	{
		this.iconCode = iconCode;
	}

	public String getIconConstant()
	{
		return iconConstant;
	}

	public void setIconConstant(String iconConstant)
	{
		this.iconConstant = iconConstant;
	}
}
