package com.namasoft.contracts.common.dtos;

import com.namasoft.common.*;
import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.entities.*;

import jakarta.xml.bind.annotation.*;
import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class LoginResult extends ServiceResponse
{
	private DTOUser userInfo;
	private DTOMenuDefinition menu;
	private DTOUserFavourites favourites;
	private DTOShortCutsDefinition shortCuts;
	private EntityDimensionsDTO dimensions;
	private Language preferedLanguage;
	private List<String> allowedEntities;
	private List<String> allowedFeatures;
	private List<String> userPreventedEntities;
	private List<String> userPreventedFeatures;
	private Boolean barCodeOn;
	private Boolean hijriDate;
	private Boolean alwaysPrint1InBarcode;
	private Boolean directPrint;
	private EntityReferenceData timedQuery;
	private Long timedQueryDelayInSeconds;
	private Integer autoLogoutTime;
	private Boolean autoLogoutRememberMe;
	private Boolean mobileVerificationCodeOn;
	private String customDimensionsDescriptionAr;
	private String customDimensionsDescriptionEn;
	private String otpId;

	public LoginResult(DTOUser userInfo, DTOMenuDefinition menu, DTOShortCutsDefinition shortCuts, Language preferedLanguage,
			List<String> allowedEntities, List<String> allowedfeatures, List<String> usrPreventedEntities, List<String> userPreventedfeatures,
			EntityDimensionsDTO loginDimensions, EntityReferenceData timedQuery, Long timedQueryDelayInSeconds, ResultDTO result,
			Integer autoLogoutTime, Boolean autoLogoutRememberMe)
	{
		super(result);
		setAutoLogoutRememberMe(autoLogoutRememberMe);
		setAutoLogoutTime(autoLogoutTime);
		setUserInfo(userInfo);
		setDimensions(loginDimensions);
		if (loginDimensions == null)
			setDimensions(new EntityDimensionsDTO(userInfo));
		setMenu(menu);
		setPreferedLanguage(preferedLanguage);
		setAllowedEntities(allowedEntities);
		setAllowedFeatures(allowedfeatures);
		setUserPreventedEntities(usrPreventedEntities);
		setUserPreventedFeatures(userPreventedfeatures);
		setShortCuts(shortCuts);
		if (userInfo != null)
		{
			setBarCodeOn(userInfo.getSettings().getBarCodeOn());
			setHijriDate(userInfo.getSettings().getHijriDate());
			setAlwaysPrint1InBarcode(userInfo.getSettings().getAlwaysPrint1InBarcode());
			setDirectPrint(userInfo.getSettings().getDirectPrint());
		}
		setTimedQuery(timedQuery);
		setTimedQueryDelayInSeconds(timedQueryDelayInSeconds);
	}

	public LoginResult mobileVerificationCodeOn(Boolean mobileVerificationCodeOn)
	{
		this.mobileVerificationCodeOn = mobileVerificationCodeOn;
		return this;
	}

	public EntityReferenceData getTimedQuery()
	{
		return timedQuery;
	}

	public void setTimedQuery(EntityReferenceData timedQuery)
	{
		this.timedQuery = timedQuery;
	}

	public Long getTimedQueryDelayInSeconds()
	{
		return timedQueryDelayInSeconds;
	}

	public void setTimedQueryDelayInSeconds(Long timedQueryDelayInSeconds)
	{
		this.timedQueryDelayInSeconds = timedQueryDelayInSeconds;
	}

	public LoginResult()
	{
		super();
	}

	public DTOUser getUserInfo()
	{
		return userInfo;
	}

	public void setUserInfo(DTOUser userInfo)
	{
		this.userInfo = userInfo;
	}

	public DTOMenuDefinition getMenu()
	{
		return menu;
	}

	public void setMenu(DTOMenuDefinition menu)
	{
		this.menu = menu;
	}

	public EntityDimensionsDTO getDimensions()
	{
		return dimensions;
	}

	public void setDimensions(EntityDimensionsDTO dimensions)
	{
		this.dimensions = dimensions;
	}

	public Language getPreferedLanguage()
	{
		return preferedLanguage;
	}

	public void setPreferedLanguage(Language preferedLanguage)
	{
		this.preferedLanguage = preferedLanguage;
	}

	public List<String> getAllowedEntities()
	{
		return allowedEntities;
	}

	public void setAllowedEntities(List<String> allowedEntities)
	{
		this.allowedEntities = allowedEntities;
	}

	public List<String> getAllowedFeatures()
	{
		return allowedFeatures;
	}

	public void setAllowedFeatures(List<String> allowedFeatures)
	{
		this.allowedFeatures = allowedFeatures;
	}

	public List<String> getUserPreventedEntities()
	{
		return userPreventedEntities;
	}

	public void setUserPreventedEntities(List<String> userPreventedEntities)
	{
		this.userPreventedEntities = userPreventedEntities;
	}

	public List<String> getUserPreventedFeatures()
	{
		return userPreventedFeatures;
	}

	public void setUserPreventedFeatures(List<String> userPreventedFeatures)
	{
		this.userPreventedFeatures = userPreventedFeatures;
	}

	public DTOShortCutsDefinition getShortCuts()
	{
		return shortCuts;
	}

	public void setShortCuts(DTOShortCutsDefinition shortCuts)
	{
		this.shortCuts = shortCuts;
	}

	public Boolean getBarCodeOn()
	{
		return barCodeOn;
	}

	public void setBarCodeOn(Boolean barCodeOn)
	{
		this.barCodeOn = barCodeOn;
	}

	public Boolean getAlwaysPrint1InBarcode()
	{
		return alwaysPrint1InBarcode;
	}

	public void setAlwaysPrint1InBarcode(Boolean alwaysPrint1InBarcode)
	{
		this.alwaysPrint1InBarcode = alwaysPrint1InBarcode;
	}

	public Boolean getDirectPrint()
	{
		return directPrint;
	}

	public void setDirectPrint(Boolean directPrint)
	{
		this.directPrint = directPrint;
	}

	public Boolean getHijriDate()
	{
		return hijriDate;
	}

	public void setHijriDate(Boolean hijriDate)
	{
		this.hijriDate = hijriDate;
	}

	public Integer getAutoLogoutTime()
	{
		return autoLogoutTime;
	}

	public void setAutoLogoutTime(Integer autoLogoutTime)
	{
		this.autoLogoutTime = autoLogoutTime;
	}

	public Boolean getAutoLogoutRememberMe()
	{
		return autoLogoutRememberMe;
	}

	public void setAutoLogoutRememberMe(Boolean autoLogoutRememberMe)
	{
		this.autoLogoutRememberMe = autoLogoutRememberMe;
	}

	public DTOUserFavourites getFavourites()
	{
		return favourites;
	}

	public void setFavourites(DTOUserFavourites favourites)
	{
		this.favourites = favourites;
	}

	public Boolean getMobileVerificationCodeOn()
	{
		return mobileVerificationCodeOn;
	}

	public void setMobileVerificationCodeOn(Boolean mobileVerificationCodeOn)
	{
		this.mobileVerificationCodeOn = mobileVerificationCodeOn;
	}

	public String getCustomDimensionsDescriptionAr()
	{
		return customDimensionsDescriptionAr;
	}

	public void setCustomDimensionsDescriptionAr(String customDimensionsDescriptionAr)
	{
		this.customDimensionsDescriptionAr = customDimensionsDescriptionAr;
	}

	public String getCustomDimensionsDescriptionEn()
	{
		return customDimensionsDescriptionEn;
	}

	public void setCustomDimensionsDescriptionEn(String customDimensionsDescriptionEn)
	{
		this.customDimensionsDescriptionEn = customDimensionsDescriptionEn;
	}

	public String getOtpId()
	{
		return otpId;
	}

	public void setOtpId(String otpId)
	{
		this.otpId = otpId;
	}
}
