package com.namasoft.contracts.common.dtos;

import com.namasoft.common.GwtTransient;
import com.namasoft.common.flatobjects.EntityReferenceData;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class MasterFileDTO extends BaseEntityDTO implements Serializable
{

	private static final long serialVersionUID = 730523745662862133L;
	private String name2;
	private String name1;
	@GwtTransient
	private DTOLargeData mainFile;
	private EntityReferenceData group;

	protected MasterFileDTO()
	{
		super();
	}

	protected MasterFileDTO(String t)
	{
		super(t);
	}

	public EntityReferenceData getGroup()
	{
		return group;
	}

	public void setGroup(EntityReferenceData group)
	{
		this.group = group;
	}

	public String getName1()
	{
		return name1;
	}

	public void setName1(String name1)
	{
		this.name1 = name1;
	}

	public String getName2()
	{
		return name2;
	}

	public void setName2(String name2)
	{
		this.name2 = name2;
	}

	public DTOLargeData getMainFile()
	{
		return mainFile;
	}

	public void setMainFile(DTOLargeData mainFile)
	{
		this.mainFile = mainFile;
	}

	public EntityReferenceData toRef()
	{
		return new EntityReferenceData(getEntityType(), getId(), getCode(), getActualCode(), getCode(), getName1(), getName2());
	}
}