package com.namasoft.contracts.common.dtos;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;
import com.namasoft.contracts.common.dtos.results.DTOTabularResult;
import com.namasoft.contracts.common.dtos.results.ListResult;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PagedDTOTabularResult extends ListResult<DTOTabularResult> implements Serializable
{
	private static final long serialVersionUID = 6447056713333087693L;
	private long totalRecordsCount = -1;
	private int pageSize = -1;
	private int pageNumber = -1;

	public PagedDTOTabularResult()
	{
		super();
	}

	public PagedDTOTabularResult(List<DTOTabularResult> results, ResultDTO resultDTO)
	{
		super(results, resultDTO);
	}

	public PagedDTOTabularResult(List<DTOTabularResult> results, ResultDTO resultDTO, long totalCount, int pageSize, int pageNumber)
	{
		super(results, resultDTO);
		this.totalRecordsCount = totalCount;
		this.pageSize = pageSize;
		this.pageNumber = pageNumber;
	}

	public long getTotalRecordsCount()
	{
		return totalRecordsCount;
	}

	public void setTotalRecordsCount(long totalRecordsCount)
	{
		this.totalRecordsCount = totalRecordsCount;
	}

	public int getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
	}

	public int getPageNumber()
	{
		return pageNumber;
	}

	public void setPageNumber(int pageNumber)
	{
		this.pageNumber = pageNumber;
	}

	@Override
	public List<DTOTabularResult> getList()
	{
		return super.getList();
	}

	@Override
	public void setList(List<DTOTabularResult> list)
	{
		super.setList(list);
	}
}
