package com.namasoft.contracts.common.dtos;

import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.GenericValue;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
public class PrintBarcodeData extends NaMaDTO
{
	private List<SingleBarCodePrint> barCodePrints = new ArrayList<SingleBarCodePrint>();

	public PrintBarcodeData()
	{
	}

	public static PrintBarcodeData createFromGenericValues(List<GenericValue> references, List<GenericValue> counts)
	{
		List<EntityReferenceData> records = new ArrayList<EntityReferenceData>();
		for (GenericValue genericValue : references)
		{
			records.add(genericValue.<EntityReferenceData> fieldValue());
		}
		List<Number> ncounts = new ArrayList<Number>();
		for (GenericValue genericValue : counts)
		{
			ncounts.add(genericValue.<Number> fieldValue());
		}
		return new PrintBarcodeData(records, ncounts);
	}

	public PrintBarcodeData(List<? extends EntityReferenceData> records, List<? extends Number> counts)
	{
		if (ObjectChecker.isAnyEmptyOrNull(records, counts))
			return;
		for (int i = 0; i < records.size() && i < counts.size(); i++)
		{
			if (ObjectChecker.areAllNotEmptyOrNull(records.get(i), counts.get(i)))
				barCodePrints.add(new SingleBarCodePrint(records.get(i), counts.get(i).intValue()));
		}
	}

	public List<SingleBarCodePrint> getBarCodePrints()
	{
		return barCodePrints;
	}

	public void setBarCodePrints(List<SingleBarCodePrint> barCodePrints)
	{
		this.barCodePrints = barCodePrints;
	}

}
