package com.namasoft.contracts.common.dtos;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.results.DTOTabularResult;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class SuggestionList extends NaMaDTO
{
	private List<SuggestionProvidedItem> suggestions = new ArrayList<SuggestionProvidedItem>();

	public List<SuggestionProvidedItem> getSuggestions()
	{
		return suggestions;
	}

	public void setSuggestions(List<SuggestionProvidedItem> suggestion)
	{
		this.suggestions = suggestion;
	}

	public static SuggestionList fromItems(List<String> codes)
	{
		SuggestionList list = new SuggestionList();
		list.addItems(codes);
		return list;
	}

	public static SuggestionList fromTabularResult(List<DTOTabularResult> values)
	{
		SuggestionList list = new SuggestionList();
		if (values == null)
			return list;
		for (DTOTabularResult result : values)
		{
			FlatObject value = (FlatObject) CommonUtils.convertToFlatObjectIfNeeded(result.get(CommonFieldIds.REFERENCE));
			list.addItem(
					new SuggestionProvidedItem(result.get(CommonFieldIds.CODE), result.get(CommonFieldIds.NAME1), result.get(CommonFieldIds.NAME2),
							value));
		}
		return list;
	}

	public SuggestionList addItems(List<String> codes)
	{
		if (codes == null)
			return this;
		for (String code : codes)
		{
			addItem(code);
		}
		return this;
	}

	public void addItem(String code)
	{
		getSuggestions().add(new SuggestionProvidedItem(code));
	}

	public void addItem(String code, String name1, String name2)
	{
		getSuggestions().add(new SuggestionProvidedItem(code, name1, name2));
	}

	public void addItem(FlatObject object)
	{
		getSuggestions().add(new SuggestionProvidedItem(object));
	}

	public void addItem(SuggestionProvidedItem item)
	{
		getSuggestions().add(item);
	}

	public void removeByCode(String code)
	{
		for (int i = getSuggestions().size() - 1; i >= 0; i--)
		{
			SuggestionProvidedItem item = getSuggestions().get(i);
			if (ObjectChecker.areEqual(item.getText().getCode(), code))
				getSuggestions().remove(i);
		}
	}

	public SuggestionList filter(String code)
	{
		if (ObjectChecker.isEmptyOrNull(code))
			return this;
		for (int i = getSuggestions().size() - 1; i >= 0; i--)
		{
			SuggestionProvidedItem item = getSuggestions().get(i);
			if (!item.isCandidate(code))
				getSuggestions().remove(i);
		}
		return this;
	}

	public static SuggestionList fromRefItems(List<EntityReferenceData> refList)
	{
		SuggestionList list = new SuggestionList();
		if (ObjectChecker.isEmptyOrNull(refList))
			return list;
		for (EntityReferenceData ref : refList)
		{
			if (ref == null)
				continue;
			list.addItem(new SuggestionProvidedItem(ref.getCode(), ref.getName1(), ref.getName2()));
		}
		return list;
	}

	public SuggestionList limit(int limit)
	{
		if (getSuggestions().size() > limit)
			setSuggestions(new ArrayList<SuggestionProvidedItem>(getSuggestions().subList(0, limit)));
		return this;
	}
}
