package com.namasoft.contracts.common.dtos;

import com.namasoft.common.*;
import com.namasoft.common.fieldids.*;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.objects.DTOTranslatedText;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SuggestionProvidedItem extends NaMaDTO implements HasId
{
	private DTOTranslatedText text;
	private FlatObject value;
	private ListOfGenericValues fieldsToUpdate;
	private String imageRecordId;
	private String imageRecordEntityType;
	private String displayCode;
	@GwtTransient
	private Object vueValue;

	public SuggestionProvidedItem(String code)
	{
		this(code, code, code, null);
	}

	public SuggestionProvidedItem(String code, String name1, String name2)
	{
		this(code, name1, name2, null);
	}

	public SuggestionProvidedItem(FlatObject value)
	{
		this((String) value.getFieldValue(CommonFieldIds.CODE), (String) ObjectChecker
						.getFirstNotEmptyObj(value.getFieldValue(CommonFieldIds.DESCRIPTOR1), value.getFieldValue(CommonFieldIds.NAME1)),
				(String) ObjectChecker
						.getFirstNotEmptyObj(value.getFieldValue(CommonFieldIds.DESCRIPTOR2), value.getFieldValue(CommonFieldIds.NAME2)), value);
	}

	public SuggestionProvidedItem(String code, String name1, String name2, FlatObject value)
	{
		text = new DTOTranslatedText(code, name1, name2);
		this.value = value;
		if (value != null)
			imageRecord(Fields.entityType(value), Fields.id(value));
	}

	public SuggestionProvidedItem()
	{
	}

	public DTOTranslatedText getText()
	{
		return text;
	}

	public void setText(DTOTranslatedText text)
	{
		this.text = text;
	}

	public FlatObject getValue()
	{
		return value;
	}

	public void setValue(FlatObject value)
	{
		this.value = value;
	}

	@Override
	@XmlTransient
	public String getId()
	{
		return text.getCode() + text.getName1() + text.getName2();
	}

	public void addToListIfNotFount(List<SuggestionProvidedItem> list)
	{
		if (HasIDUtil.find(getId(), list) == null)
			list.add(this);
	}

	public SuggestionProvidedItem fieldsToUpdate(ListOfGenericValues fieldsToUpdate)
	{
		setFieldsToUpdate(fieldsToUpdate);
		return this;
	}

	public SuggestionProvidedItem addFieldToUpdate(String id, Object value)
	{
		return addFieldToUpdate(new GenericValue(id, value));
	}
	public SuggestionProvidedItem addFieldToUpdate(GenericValue fieldToUpdate)
	{
		if (getFieldsToUpdate() == null)
			setFieldsToUpdate(new ListOfGenericValues());
		getFieldsToUpdate().addValue(fieldToUpdate);
		return this;
	}

	public ListOfGenericValues getFieldsToUpdate()
	{
		return fieldsToUpdate;
	}

	public void setFieldsToUpdate(ListOfGenericValues fieldsToUpdate)
	{
		this.fieldsToUpdate = fieldsToUpdate;
	}

	public String getImageRecordId()
	{
		return imageRecordId;
	}

	public void setImageRecordId(String imageRecordId)
	{
		this.imageRecordId = imageRecordId;
	}

	public String getImageRecordEntityType()
	{
		return imageRecordEntityType;
	}

	public void setImageRecordEntityType(String imageRecordEntityType)
	{
		this.imageRecordEntityType = imageRecordEntityType;
	}

	public SuggestionProvidedItem imageRecord(String entiityType, String id)
	{
		if (ObjectChecker.areAllNotEmptyOrNull(entiityType, id))
		{
			setImageRecordEntityType(entiityType);
			setImageRecordId(id);
		}
		return this;
	}

	public SuggestionProvidedItem imageRecord(EntityReferenceData ref)
	{
		if (ObjectChecker.isNotEmptyOrNull(ref))
			return imageRecord(ref.getEntityType(), ref.getId());
		else
			return this;
	}

	public String getDisplayCode()
	{
		return displayCode;
	}

	public void setDisplayCode(String displayCode)
	{
		this.displayCode = displayCode;
	}

	public SuggestionProvidedItem displayCode(String displayCode)
	{
		setDisplayCode(displayCode);
		return this;
	}

	@Override
	public boolean equals(Object o)
	{
		if (this == o)
			return true;
		if (o == null || !(o instanceof SuggestionProvidedItem))
			return false;
		SuggestionProvidedItem that = (SuggestionProvidedItem) o;
		return Objects.equals(getId(), that.getId());
	}

	@Override
	public int hashCode()
	{
		return getId().hashCode();
	}

	public boolean isCandidate(String code)
	{
		code = code.toLowerCase();
		return ObjectChecker.toStringOrEmpty(getText().getCode()).toLowerCase().contains(code) || ObjectChecker.toStringOrEmpty(getText().getName1())
				.toLowerCase().contains(code) || ObjectChecker.toStringOrEmpty(getText().getName2()).toLowerCase().contains(code);
	}

	public Object getVueValue()
	{
		return vueValue;
	}

	public void setVueValue(Object vueValue)
	{
		this.vueValue = vueValue;
	}
}
