package com.namasoft.contracts.common.dtos.config;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.constants.ACCEntities;
import com.namasoft.common.constants.DomainBaseEntities;
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOAccountDimensionConfigurations extends NaMaDTO
{
	private static final long serialVersionUID = 5193731250734818492L;
	private int sectorSegmentOrder = 1;
	private int branchSegmentOrder = 2;
	private int departmentSegmentOrder = 3;
	private int analysisSetSegmentOrder = 4;
	private String segmentSeperator = "-";

	public int getSectorSegmentOrder()
	{
		return sectorSegmentOrder;
	}

	public void setSectorSegmentOrder(int sectorSegmentOrder)
	{
		this.sectorSegmentOrder = sectorSegmentOrder;
	}

	public int getBranchSegmentOrder()
	{
		return branchSegmentOrder;
	}

	public void setBranchSegmentOrder(int branchSegmentOrder)
	{
		this.branchSegmentOrder = branchSegmentOrder;
	}

	public int getDepartmentSegmentOrder()
	{
		return departmentSegmentOrder;
	}

	public void setDepartmentSegmentOrder(int departmentSegmentOrder)
	{
		this.departmentSegmentOrder = departmentSegmentOrder;
	}

	public int getAnalysisSetSegmentOrder()
	{
		return analysisSetSegmentOrder;
	}

	public void setAnalysisSetSegmentOrder(int analysisSetSegmentOrder)
	{
		this.analysisSetSegmentOrder = analysisSetSegmentOrder;
	}

	public String getSegmentSeperator()
	{
		return segmentSeperator;
	}

	public void setSegmentSeperator(String segmentSeperator)
	{
		this.segmentSeperator = segmentSeperator;
	}

	public int calculateNumberOfSegments()
	{
		int num = 0;
		if (getSectorSegmentOrder() > 0)
			num++;
		if (getAnalysisSetSegmentOrder() > 0)
			num++;
		if (getBranchSegmentOrder() > 0)
			num++;
		if (getDepartmentSegmentOrder() > 0)
			num++;
		return num;
	}

	public static DimensionsIdsOrCodes parseDimensions(String text,DTOAccountDimensionConfigurations dimensionConfigurations)
	{
		DimensionsIdsOrCodes dimensionsIds = new DimensionsIdsOrCodes();
		if (dimensionConfigurations.calculateNumberOfSegments() < 1)
			return dimensionsIds;
		String[] segments = text.split(dimensionConfigurations.getSegmentSeperator());
		int numOfSegments = segments.length;
		if (dimensionConfigurations.getSectorSegmentOrder() > 0 && dimensionConfigurations.getSectorSegmentOrder() < numOfSegments)
		{
			dimensionsIds.setSector(segments[dimensionConfigurations.getSectorSegmentOrder()]);
		}
		if (dimensionConfigurations.getBranchSegmentOrder() > 0 && dimensionConfigurations.getBranchSegmentOrder() < numOfSegments)
		{
			dimensionsIds.setBranch(segments[dimensionConfigurations.getBranchSegmentOrder()]);
		}
		if (dimensionConfigurations.getDepartmentSegmentOrder() > 0 && dimensionConfigurations.getDepartmentSegmentOrder() < numOfSegments)
		{
			dimensionsIds.setDepartment(segments[dimensionConfigurations.getDepartmentSegmentOrder()]);
		}
		if (dimensionConfigurations.getAnalysisSetSegmentOrder() > 0 && dimensionConfigurations.getAnalysisSetSegmentOrder() < numOfSegments)
		{
			dimensionsIds.setAnalysisSet(segments[dimensionConfigurations.getAnalysisSetSegmentOrder()]);
		}
		return dimensionsIds;
	}

	public String getDimensionTypeFromOrder(int order)
	{
		if (order < 0)
			return null;
		if (order == 0)
			return ACCEntities.Account;
		if (getAnalysisSetSegmentOrder() == order)
			return DomainBaseEntities.AnalysisSet;
		if (getBranchSegmentOrder() == order)
			return DomainBaseEntities.Branch;
		if (getDepartmentSegmentOrder() == order)
			return DomainBaseEntities.Department;
		if (getSectorSegmentOrder() == order)
			return DomainBaseEntities.Sector;
		return null;
	}
}
