package com.namasoft.contracts.common.dtos.config;

import java.util.*;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.modules.commonbasic.contracts.valueobjects.*;
import com.namasoft.common.utils.tafqeet.CurrencyDetails;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOGlobalConfig extends NaMaDTO
{
	private Boolean approvalEnabled;
	private Boolean trackVersionsEnabled;
	private String branchConsistencyLevel;
	private String sectorConsistencyLevel;
	private String departmentConsistencyLevel;
	private String analysisSetConsistencyLevel;
	private Boolean branchEnabled;
	private Boolean sectorEnabled;
	private Boolean departmentEnabled;
	private Boolean analysisSetEnabled;
	private Boolean branchAcessibilityEnabled;
	private Boolean sectorAcessibilityEnabled;
	private Boolean departmentAcessibilityEnabled;
	private Boolean analysisSetAcessibilityEnabled;
	private Integer branchOrder;
	private Integer sectorOrder;
	private Integer departmentOrder;
	private Integer analysisSetOrder;
	private HashMap<String, DTOGlobalEntityConfig> entityConfigs = new HashMap<String, DTOGlobalEntityConfig>();
	private DTOAccountDimensionConfigurations accountDimensionConfigurations;
	private DTOMeasuresConfiguration measuresConfiguration;
	private DTOGlobalConfigInfo info;
	private String discountLocation;
	private Boolean useUpdateEmpInfoDoc;

	public String getBranchConsistencyLevel()
	{
		return branchConsistencyLevel;
	}

	public void setBranchConsistencyLevel(String branchConsistencyLevel)
	{
		this.branchConsistencyLevel = branchConsistencyLevel;
	}

	public String getSectorConsistencyLevel()
	{
		return sectorConsistencyLevel;
	}

	public void setSectorConsistencyLevel(String sectorConsistencyLevel)
	{
		this.sectorConsistencyLevel = sectorConsistencyLevel;
	}

	public String getDepartmentConsistencyLevel()
	{
		return departmentConsistencyLevel;
	}

	public void setDepartmentConsistencyLevel(String departmentConsistencyLevel)
	{
		this.departmentConsistencyLevel = departmentConsistencyLevel;
	}

	public String getAnalysisSetConsistencyLevel()
	{
		return analysisSetConsistencyLevel;
	}

	public void setAnalysisSetConsistencyLevel(String analysisSetConsistencyLevel)
	{
		this.analysisSetConsistencyLevel = analysisSetConsistencyLevel;
	}

	public Boolean getApprovalEnabled()
	{
		return approvalEnabled;
	}

	public void setApprovalEnabled(Boolean approvalEnabled)
	{
		this.approvalEnabled = approvalEnabled;
	}

	public Integer getBranchOrder()
	{
		return branchOrder;
	}

	public void setBranchOrder(Integer branchOrder)
	{
		this.branchOrder = branchOrder;
	}

	public Integer getSectorOrder()
	{
		return sectorOrder;
	}

	public void setSectorOrder(Integer sectorOrder)
	{
		this.sectorOrder = sectorOrder;
	}

	public Integer getDepartmentOrder()
	{
		return departmentOrder;
	}

	public void setDepartmentOrder(Integer departmentOrder)
	{
		this.departmentOrder = departmentOrder;
	}

	public Integer getAnalysisSetOrder()
	{
		return analysisSetOrder;
	}

	public void setAnalysisSetOrder(Integer analysisSetOrder)
	{
		this.analysisSetOrder = analysisSetOrder;
	}

	public Boolean getTrackVersionsEnabled()
	{
		return trackVersionsEnabled;
	}

	public void setTrackVersionsEnabled(Boolean trackVersionsEnabled)
	{
		this.trackVersionsEnabled = trackVersionsEnabled;
	}

	public Boolean getBranchEnabled()
	{
		return branchEnabled;
	}

	public void setBranchEnabled(Boolean branchEnabled)
	{
		this.branchEnabled = branchEnabled;
	}

	public Boolean getSectorEnabled()
	{
		return sectorEnabled;
	}

	public void setSectorEnabled(Boolean sectorEnabled)
	{
		this.sectorEnabled = sectorEnabled;
	}

	public Boolean getDepartmentEnabled()
	{
		return departmentEnabled;
	}

	public void setDepartmentEnabled(Boolean departmentEnabled)
	{
		this.departmentEnabled = departmentEnabled;
	}

	public Boolean getAnalysisSetEnabled()
	{
		return analysisSetEnabled;
	}

	public void setAnalysisSetEnabled(Boolean analysisSetEnabled)
	{
		this.analysisSetEnabled = analysisSetEnabled;
	}

	public HashMap<String, DTOGlobalEntityConfig> getEntityConfigs()
	{
		return entityConfigs;
	}

	public void setEntityConfigs(HashMap<String, DTOGlobalEntityConfig> entityConfigs)
	{
		this.entityConfigs = entityConfigs;
	}

	public Boolean getBranchAcessibilityEnabled()
	{
		return branchAcessibilityEnabled;
	}

	public void setBranchAcessibilityEnabled(Boolean branchAcessibilityEnabled)
	{
		this.branchAcessibilityEnabled = branchAcessibilityEnabled;
	}

	public Boolean getSectorAcessibilityEnabled()
	{
		return sectorAcessibilityEnabled;
	}

	public void setSectorAcessibilityEnabled(Boolean sectorAcessibilityEnabled)
	{
		this.sectorAcessibilityEnabled = sectorAcessibilityEnabled;
	}

	public Boolean getDepartmentAcessibilityEnabled()
	{
		return departmentAcessibilityEnabled;
	}

	public void setDepartmentAcessibilityEnabled(Boolean departmentAcessibilityEnabled)
	{
		this.departmentAcessibilityEnabled = departmentAcessibilityEnabled;
	}

	public Boolean getAnalysisSetAcessibilityEnabled()
	{
		return analysisSetAcessibilityEnabled;
	}

	public void setAnalysisSetAcessibilityEnabled(Boolean analysisSetAcessibilityEnabled)
	{
		this.analysisSetAcessibilityEnabled = analysisSetAcessibilityEnabled;
	}

	public DTOAccountDimensionConfigurations getAccountDimensionConfigurations()
	{
		return accountDimensionConfigurations;
	}

	public void setAccountDimensionConfigurations(DTOAccountDimensionConfigurations accountDimensionConfigurations)
	{
		this.accountDimensionConfigurations = accountDimensionConfigurations;
	}

	public DTOMeasuresConfiguration getMeasuresConfiguration()
	{
		return measuresConfiguration;
	}

	public void setMeasuresConfiguration(DTOMeasuresConfiguration measuresConfiguration)
	{
		this.measuresConfiguration = measuresConfiguration;
	}

	public DTOGlobalConfigInfo getInfo()
	{
		return info;
	}

	public void setInfo(DTOGlobalConfigInfo info)
	{
		this.info = info;
	}

	public String getDiscountLocation()
	{
		return discountLocation;
	}

	public void setDiscountLocation(String discountLocation)
	{
		this.discountLocation = discountLocation;
	}

	public Boolean getUseUpdateEmpInfoDoc()
	{
		return useUpdateEmpInfoDoc;
	}

	public void setUseUpdateEmpInfoDoc(Boolean useUpdateEmpInfoDoc)
	{
		this.useUpdateEmpInfoDoc = useUpdateEmpInfoDoc;
	}

	public void loadOtherCurrencyDetails()
	{
		if (getInfo() == null || getInfo().getTafqeetInfo() == null)
			return;
		HashMap<String, CurrencyDetails> currencyDetails = new HashMap<String, CurrencyDetails>();
		List<DTOCurrencyTafqeetInfo> tafqeetInfo = getInfo().getTafqeetInfo();
		for (DTOCurrencyTafqeetInfo currencyTafqeetInfo : tafqeetInfo)
		{
			CurrencyDetails detail = new CurrencyDetails();
			detail.setArabic1199CurrencyName(currencyTafqeetInfo.getArabic1199CurrencyName());
			detail.setArabic1199CurrencyPartName(currencyTafqeetInfo.getArabic1199CurrencyPartName());
			detail.setArabic1CurrencyName(currencyTafqeetInfo.getArabic1CurrencyName());
			detail.setArabic2CurrencyPartName(currencyTafqeetInfo.getArabic2CurrencyPartName());
			detail.setArabic310CurrencyName(currencyTafqeetInfo.getArabic310CurrencyName());
			detail.setArabic310CurrencyPartName(currencyTafqeetInfo.getArabic310CurrencyPartName());
			detail.setCode(currencyTafqeetInfo.getCurrencyCode());
			detail.setCurrencyNameFeminine(currencyTafqeetInfo.getCurrencyNameFeminine());
			detail.setCurrencyPartNameFeminine(currencyTafqeetInfo.getCurrencyPartNameFeminine());
			detail.setDescription(currencyTafqeetInfo.getDescription());
			detail.setEnglishCurrencyName(currencyTafqeetInfo.getEnglishCurrencyName());
			detail.setEnglishCurrencyPartName(currencyTafqeetInfo.getEnglishCurrencyPartName());
			detail.setEnglishPluralCurrencyName(currencyTafqeetInfo.getEnglishpluralCurrencyName());
			detail.setEnglishPluralCurrencyPartName(currencyTafqeetInfo.getEnglishPluralCurrencyPartName());
			detail.setPartPrecision(currencyTafqeetInfo.getPartPrecision());
			currencyDetails.put(currencyTafqeetInfo.getCurrencyCode(), detail);
			detail.setArabic1CurrencyPartName(currencyTafqeetInfo.getArabic1CurrencyPartName());
			detail.setArabic2CurrencyName(currencyTafqeetInfo.getArabic2CurrencyName());

		}
		CurrencyDetails.setOtherDetails(currencyDetails);
	}
}
