package com.namasoft.contracts.common.dtos.config;

import static com.namasoft.common.utilities.ObjectChecker.*;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.EntityDimensionsDTO;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class DimensionsIdsOrCodes implements Serializable,NamaObject
{
	private static final long serialVersionUID = 2666109203683039590L;
	private String legalEntity;
	private String sector;
	private String branch;
	private String analysisSet;
	private String department;

	public DimensionsIdsOrCodes()
	{

	}

	public DimensionsIdsOrCodes(EntityDimensionsDTO entityDimensionsDTO)
	{
		if (entityDimensionsDTO == null)
			return;
		if (ObjectChecker.isNotEmptyOrNull(entityDimensionsDTO.getLegalEntity()))
			legalEntity = entityDimensionsDTO.getLegalEntity().getId();
		if (ObjectChecker.isNotEmptyOrNull(entityDimensionsDTO.getSector()))
			sector = entityDimensionsDTO.getSector().getId();
		if (ObjectChecker.isNotEmptyOrNull(entityDimensionsDTO.getBranch()))
			branch = entityDimensionsDTO.getBranch().getId();
		if (ObjectChecker.isNotEmptyOrNull(entityDimensionsDTO.getAnalysisSet()))
			analysisSet = entityDimensionsDTO.getAnalysisSet().getId();
		if (ObjectChecker.isNotEmptyOrNull(entityDimensionsDTO.getDepartment()))
			department = entityDimensionsDTO.getDepartment().getId();
	}

	public String getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(String legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public String getSector()
	{
		return sector;
	}

	public void setSector(String sector)
	{
		this.sector = sector;
	}

	public String getBranch()
	{
		return branch;
	}

	public void setBranch(String branch)
	{
		this.branch = branch;
	}

	public String getAnalysisSet()
	{
		return analysisSet;
	}

	public void setAnalysisSet(String analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public String getDepartment()
	{
		return department;
	}

	public void setDepartment(String department)
	{
		this.department = department;
	}

	public boolean isEmpty()
	{
		return isEmptyOrNull(getSector()) && isEmptyOrNull(getBranch()) && isEmptyOrNull(getAnalysisSet()) && isEmptyOrNull(getDepartment()) && isEmptyOrNull(getLegalEntity());
	}
}
