package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteriaBuilder;

public class AGGridTextFilterModel extends AGGridISimpleFilterModel
{
	private String filter;
	private String filterTo;

	public AGGridTextFilterModel()
	{
	}

	@Override
	public void appendExpression(DTOCriteriaBuilder.DTOExpressionBuilder expressionBuilder, String fieldId, String fieldType)
	{
		DTOCriteriaBuilder.DTOExpressionBuilder exp = expressionBuilder.and().field(fieldId);
		switch (getType())
		{
		case blank -> exp.isNull();
		case notBlank -> exp.isNotNull();
		case equals -> exp.equal(filter);
		case notEqual -> exp.notEqual(filter);
		case startsWith -> exp.startsWith(filter);
		case endsWith -> exp.endsWith(filter);
		case contains -> exp.contains(filter);
		case notContains -> exp.notContains(filter);
		}
	}

	public String getFilter()
	{
		return filter;
	}

	public void setFilter(String filter)
	{
		this.filter = filter;
	}

	public String getFilterTo()
	{
		return filterTo;
	}

	public void setFilterTo(String filterTo)
	{
		this.filterTo = filterTo;
	}
}
