package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.criteria.DTOCriteria;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ByCodeRequest extends EntityServiceRequest implements IListOrTabularRequest
{
	private String code;
	private DTOCriteria criteria;
	private String searchInsideFieldId;
	private String searchInsideEntity;
	public ByCodeRequest()
	{
	}

	public ByCodeRequest(String entityType, String code)
	{
		super(entityType);
		this.code = code;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	@Override
	public String getSearchInsideFieldId()
	{
		return searchInsideFieldId;
	}

	@Override
	public void setSearchInsideFieldId(String searchInsideFieldId)
	{
		this.searchInsideFieldId = searchInsideFieldId;
	}

	@Override
	public String getSearchInsideEntity()
	{
		return searchInsideEntity;
	}

	@Override
	public void setSearchInsideEntity(String searchInsideEntity)
	{
		this.searchInsideEntity = searchInsideEntity;
	}
}