package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CollectTaxesReq extends NaMaDTO
{
	private List<EntityReferenceData> items;
	private EntityReferenceData legalEntity;
	private Date valueDate;
	private String entityType;
	public CollectTaxesReq()
	{
	}

	public CollectTaxesReq(List<EntityReferenceData> items, EntityReferenceData legalEntity, Date valueDate, String entityType)
	{
		this();
		this.items = items;
		this.legalEntity = legalEntity;
		this.valueDate = valueDate;
		this.entityType = entityType;
	}

	public List<EntityReferenceData> getItems()
	{
		return items;
	}

	public void setItems(List<EntityReferenceData> items)
	{
		this.items = items;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public Date getValueDate()
	{
		return valueDate;
	}

	public void setValueDate(Date valueDate)
	{
		this.valueDate = valueDate;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}
}
