package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.contracts.common.dtos.CustomPostActionReq;
import jakarta.xml.bind.annotation.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CreateNewRequest extends EntityServiceRequest
{
	private String templateId;
	private Boolean doNotUseDefaultTemplate;
	private CustomPostActionReq customQuickCreateContext;
	private String viewName;
	private String menuCode;
	private FlatObject currentObject;
	private FlatObject containerObjectForEmbeddedEdit;
	private String objectInitializationFieldMap;
	public CreateNewRequest()
	{
		super();
	}

	public CreateNewRequest(String entityType)
	{
		super(entityType);
	}

	public CreateNewRequest(String entityType, String templateId)
	{
		this(entityType);
		this.templateId = templateId;
	}

	public String getTemplateId()
	{
		return templateId;
	}

	public void setTemplateId(String templateId)
	{
		this.templateId = templateId;
	}

	public Boolean getDoNotUseDefaultTemplate()
	{
		return doNotUseDefaultTemplate;
	}

	public void setDoNotUseDefaultTemplate(Boolean doNotUseDefaultTemplate)
	{
		this.doNotUseDefaultTemplate = doNotUseDefaultTemplate;
	}

	public CustomPostActionReq getCustomQuickCreateContext()
	{
		return customQuickCreateContext;
	}

	public void setCustomQuickCreateContext(CustomPostActionReq customQuickCreateContext)
	{
		this.customQuickCreateContext = customQuickCreateContext;
	}

	public static CreateNewRequest forImport(String entityType)
	{
		CreateNewRequest req = new CreateNewRequest(entityType);
		req.setDoNotUseDefaultTemplate(true);
		return req;
	}

	public String getViewName()
	{
		return viewName;
	}

	public void setViewName(String viewName)
	{
		this.viewName = viewName;
	}

	public String getMenuCode()
	{
		return menuCode;
	}

	public void setMenuCode(String menuCode)
	{
		this.menuCode = menuCode;
	}

	public FlatObject getCurrentObject()
	{
		return currentObject;
	}

	public void setCurrentObject(FlatObject currentObject)
	{
		this.currentObject = currentObject;
	}

	public String getObjectInitializationFieldMap()
	{
		return objectInitializationFieldMap;
	}

	public void setObjectInitializationFieldMap(String objectInitializationFieldMap)
	{
		this.objectInitializationFieldMap = objectInitializationFieldMap;
	}

	public FlatObject getContainerObjectForEmbeddedEdit()
	{
		return containerObjectForEmbeddedEdit;
	}

	public void setContainerObjectForEmbeddedEdit(FlatObject containerObjectForEmbeddedEdit)
	{
		this.containerObjectForEmbeddedEdit = containerObjectForEmbeddedEdit;
	}
}
