package com.namasoft.contracts.common.dtos.requests;

import java.util.Date;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CurrencyRateRequest extends ServiceRequest
{
	private EntityReferenceData legalEntity;
	private EntityReferenceData ledger;
	private EntityReferenceData currency;
	private EntityReferenceData fiscalYear;
	private EntityReferenceData fiscalPeriod;
	private Date onDate;

	public CurrencyRateRequest()
	{
		super();
	}

	public static CurrencyRateRequest forLegalEntity(EntityReferenceData legalEntity, EntityReferenceData currency)
	{
		CurrencyRateRequest request = new CurrencyRateRequest();
		request.setLegalEntity(legalEntity);
		request.setCurrency(currency);
		return request;
	}

	public static CurrencyRateRequest forLedger(EntityReferenceData ledger, EntityReferenceData currency)
	{
		CurrencyRateRequest request = new CurrencyRateRequest();
		request.setLedger(ledger);
		request.setCurrency(currency);
		return request;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public EntityReferenceData getLedger()
	{
		return ledger;
	}

	public void setLedger(EntityReferenceData ledger)
	{
		this.ledger = ledger;
	}

	public EntityReferenceData getCurrency()
	{
		return currency;
	}

	public void setCurrency(EntityReferenceData currency)
	{
		this.currency = currency;
	}

	public Date getOnDate()
	{
		return onDate;
	}

	public void setOnDate(Date onDate)
	{
		this.onDate = onDate;
	}

	public EntityReferenceData getFiscalYear()
	{
		return fiscalYear;
	}

	public void setFiscalYear(EntityReferenceData fiscalYear)
	{
		this.fiscalYear = fiscalYear;
	}

	public EntityReferenceData getFiscalPeriod()
	{
		return fiscalPeriod;
	}

	public void setFiscalPeriod(EntityReferenceData fiscalPeriod)
	{
		this.fiscalPeriod = fiscalPeriod;
	}

	public CurrencyRateRequest fiscalYear(EntityReferenceData fiscalYear)
	{
		setFiscalYear(fiscalYear);
		return this;
	}

	public CurrencyRateRequest fiscalPeriod(EntityReferenceData fiscalPeriod)
	{
		setFiscalPeriod(fiscalPeriod);
		return this;
	}

	public CurrencyRateRequest onDate(Date onDate)
	{
		setOnDate(onDate);
		return this;
	}

}
