package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.contracts.common.dtos.config.DimensionsIdsOrCodes;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DimensionByCodeRequest extends ServiceRequest
{
	private static final long serialVersionUID = -3022875638408549947L;
	private DimensionsIdsOrCodes dimensionsCodes;
	
	public DimensionByCodeRequest()
	{
		super();
	}
	
	public DimensionByCodeRequest(DimensionsIdsOrCodes dimensionsCodes)
	{
		super();
		this.dimensionsCodes = dimensionsCodes;
	}

	public DimensionsIdsOrCodes getDimensionsCodes()
	{
		return dimensionsCodes;
	}

	public void setDimensionsCodes(DimensionsIdsOrCodes dimensionsIds)
	{
		this.dimensionsCodes = dimensionsIds;
	}
}
