package com.namasoft.contracts.common.dtos.requests;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.DTOConfirmation;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class EntityOperationRequest extends EntityServiceRequest implements ExportableRequest
{
	public static final String UNREVISE_IF_NEEDED = "unreviseIfNeeded@@##***------22335";
	private EntityReferenceData entity;
	private boolean skipExporting = false;
	private boolean importing = false;
	private List<DTOConfirmation> confirmations;

	public EntityOperationRequest(EntityReferenceData entity)
	{
		this.entity = entity;
		setEntityType(entity.getEntityType());
	}

	public EntityOperationRequest(String entityType, String id, String code)
	{
		this(new EntityReferenceData(entityType, id, code, code));
	}

	public EntityOperationRequest()
	{
	}

	public EntityReferenceData getEntity()
	{
		return entity;
	}

	public void setEntity(EntityReferenceData entity)
	{
		this.entity = entity;
	}

	@Override
	public boolean isSkipExporting()
	{
		return skipExporting;
	}

	public void setSkipExporting(boolean skipExporting)
	{
		this.skipExporting = skipExporting;
	}

	@Override
	public boolean isImporting()
	{
		return importing;
	}

	public void setImporting(boolean importing)
	{
		this.importing = importing;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

}
