package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EntityPutRequest<T> extends EntityServiceRequest
{
	private T value;

	public T getValue()
	{
		return value;
	}

	public void setValue(T value)
	{
		this.value = value;
	}

	public EntityPutRequest(String entityType, T value)
	{
		super(entityType);
		setValue(value);
	}

	public EntityPutRequest()
	{
		super();
	}
}
