package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EntityServiceRequest extends ServiceRequest
{
	private String entityType;

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public EntityServiceRequest(String entityType)
	{
		this();
		setEntityType(entityType);
	}

	public EntityServiceRequest()
	{
		super();
	}

	public EntityServiceRequest(EntityServiceRequest request)
	{
		super(request);
		if (request != null)
			setEntityType(request.getEntityType());
	}

}
