package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class FindByBusinessCodeRequest extends FindRequest
{

	private static final long serialVersionUID = -2272569673714625666L;
	private String code;

	protected FindByBusinessCodeRequest()
	{
	}

	public FindByBusinessCodeRequest(String entityType, String code)
	{
		this(entityType, code, false);
	}

	public FindByBusinessCodeRequest(EntityReferenceData ref)
	{
		this(ref.getEntityType(), ref.getCode());
	}

	public FindByBusinessCodeRequest(String entityType, String code, Boolean findDraft)
	{
		super(findDraft, entityType);
		setCode(code);
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

}
