package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.KeyList;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class IntegratorRequest extends NaMaDTO
{
	private String integratorId;
	private String urlUser;
	private String urlPassword;
	private Boolean authenticateRequest;
	private List<KeyList> parameters;

	public String getIntegratorId()
	{
		return integratorId;
	}

	public void setIntegratorId(String integratorId)
	{
		this.integratorId = integratorId;
	}

	public String getUrlUser()
	{
		return urlUser;
	}

	public void setUrlUser(String urlUser)
	{
		this.urlUser = urlUser;
	}

	public String getUrlPassword()
	{
		return urlPassword;
	}

	public void setUrlPassword(String urlPassword)
	{
		this.urlPassword = urlPassword;
	}

	public List<KeyList> getParameters()
	{
		if (parameters == null)
			parameters = new ArrayList<>();
		return parameters;
	}

	public void setParameters(List<KeyList> parameters)
	{
		this.parameters = parameters;
	}

	public Map<String,String> parametersToMap()
	{
		return KeyList.toStringMap(getParameters());
	}

	public Boolean getAuthenticateRequest()
	{
		return authenticateRequest;
	}

	public void setAuthenticateRequest(Boolean authenticateRequest)
	{
		this.authenticateRequest = authenticateRequest;
	}
}
