package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.EntityReferenceData;

public class ListApprovalsRequest extends ServiceRequest
{
	private static final long serialVersionUID = -5262893205833894475L;
	private String entityType;
	private String employeeId;
	private Integer stepSequence;

	public ListApprovalsRequest()
	{
		super();
	}

	public ListApprovalsRequest(String employee)
	{
		this(employee, null, null);
	}

	public ListApprovalsRequest(EntityReferenceData employee)
	{
		this(employee == null ? "" : employee.getId(), null, null);
	}

	public ListApprovalsRequest(EntityReferenceData employee, Integer stepSequence, String entityType)
	{
		this(employee == null ? "" : employee.getId(), stepSequence, entityType);
	}
	public ListApprovalsRequest(String employeeId, Integer stepSequence, String entityType)
	{
		super();
		this.employeeId = employeeId;
		this.stepSequence = stepSequence;
		this.entityType = entityType;
	}

	public String getEmployeeId()
	{
		return employeeId;
	}

	public void setEmployeeId(String employeeId)
	{
		this.employeeId = employeeId;
	}

	public Integer getStepSequence()
	{
		return stepSequence;
	}

	public void setStepSequence(Integer stepSequence)
	{
		this.stepSequence = stepSequence;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}
}
