package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ListPageRequest extends EntityServiceRequest
{
	private static final long serialVersionUID = -2820385201407810931L;
	private Integer page;
	private Integer pageSize;
	private String orderBy;
	private Boolean findDraft;
	private String mobileEntityType;
	private String ownerMobileEntityType;
	private String mobileFieldId;

	public ListPageRequest()
	{
		super();
	}

	public ListPageRequest(String entityType, Integer page, Integer pageSize, String orderBy, Boolean findDraft)
	{
		super(entityType);
		this.page = page;
		this.pageSize = pageSize;
		this.orderBy = orderBy;
		this.findDraft = findDraft;
	}

	public Integer getPage()
	{
		return page;
	}

	public void setPage(Integer page)
	{
		this.page = page;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
	}

	public String getOrderBy()
	{
		return orderBy;
	}

	public void setOrderBy(String orderBy)
	{
		this.orderBy = orderBy;
	}

	public Boolean getFindDraft()
	{
		return findDraft;
	}

	public void setFindDraft(Boolean findDraft)
	{
		this.findDraft = findDraft;
	}

	public String getMobileEntityType()
	{
		return mobileEntityType;
	}

	public void setMobileEntityType(String mobileEntityType)
	{
		this.mobileEntityType = mobileEntityType;
	}

	public String getOwnerMobileEntityType()
	{
		return ownerMobileEntityType;
	}

	public void setOwnerMobileEntityType(String ownerMobileEntityType)
	{
		this.ownerMobileEntityType = ownerMobileEntityType;
	}

	public String getMobileFieldId()
	{
		return mobileFieldId;
	}

	public void setMobileFieldId(String mobileFieldId)
	{
		this.mobileFieldId = mobileFieldId;
	}
}