package com.namasoft.contracts.common.dtos.requests;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListRequest extends ListRequestBase
{
	private Boolean guessMissingMetaData = false;
	private Boolean forQuickFilterColumnValues;
	private int startPage = -1;
	private int pageSize = -1;
	private List<String> displayedColumns;
	private String valueToSearch;
	private List<String> columnsToSearchIn;
	public ListRequest(String entityType)
	{
		super(entityType);
	}

	public ListRequest()
	{
		super();
	}

	public ListRequest(ListRequestBase request, int startPage, int pageSize, boolean ascending)
	{
		super(request);
		this.startPage = startPage;
		this.pageSize = pageSize;
		setAscending(ascending);
	}

	public int getStartPage()
	{
		return startPage;
	}

	public void setStartPage(int startPage)
	{
		this.startPage = startPage;
	}

	public int getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
	}

	public Boolean getGuessMissingMetaData()
	{
		return guessMissingMetaData;
	}

	public void setGuessMissingMetaData(Boolean guessMissingMetaData)
	{
		this.guessMissingMetaData = guessMissingMetaData;
	}

	public List<String> getDisplayedColumns()
	{
		return displayedColumns;
	}

	public void setDisplayedColumns(List<String> displayedColumns)
	{
		this.displayedColumns = displayedColumns;
	}

	public void setValueToSearch(String valueToSearch)
	{
		this.valueToSearch = valueToSearch;
	}

	public String getValueToSearch()
	{
		return valueToSearch;
	}

	public void setColumnsToSearchIn(List<String> columnsToSearchIn)
	{
		this.columnsToSearchIn = columnsToSearchIn;
	}

	public List<String> getColumnsToSearchIn()
	{
		return columnsToSearchIn;
	}

	public Boolean getForQuickFilterColumnValues()
	{
		return forQuickFilterColumnValues;
	}

	public void setForQuickFilterColumnValues(Boolean forQuickFilterColumnValues)
	{
		this.forQuickFilterColumnValues = forQuickFilterColumnValues;
	}
}
