package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.ILoginRequest;
import jakarta.xml.bind.annotation.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class LoginRequest extends ServiceRequest implements ILoginRequest
{
	private boolean grantAccess;
	private String grantAccessId;
	private String verificationCode;
	private Boolean appLogin;
	private static final long serialVersionUID = 7183321627686495319L;

	public LoginRequest()
	{
	}

	public LoginRequest(String loginId, String password)
	{
		this(loginId, password, false, "");
	}

	public LoginRequest(String loginId, String password, String otpId)
	{
		this(loginId, password, false, "");
		setOtpId( otpId);
	}

	public LoginRequest(String loginId, String password, boolean grantAccess, String grantAccessId)
	{
		super(loginId, password);
		this.grantAccess = grantAccess;
		this.grantAccessId = grantAccessId;
	}

	public boolean isGrantAccess()
	{
		return grantAccess;
	}

	public void setGrantAccess(boolean grantAccess)
	{
		this.grantAccess = grantAccess;
	}

	public String getGrantAccessId()
	{
		return grantAccessId;
	}

	public void setGrantAccessId(String grantAccessId)
	{
		this.grantAccessId = grantAccessId;
	}

	public String getVerificationCode()
	{
		return verificationCode;
	}

	public void setVerificationCode(String verificationCode)
	{
		this.verificationCode = verificationCode;
	}

	public Boolean getAppLogin()
	{
		return appLogin;
	}

	public void setAppLogin(Boolean appLogin)
	{
		this.appLogin = appLogin;
	}
}
