package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class MarkRevisedRequest extends ByIdRequest
{
	private boolean revised = false;

	public MarkRevisedRequest(EntityReferenceData ref)
	{
		super(ref.getEntityType(), ref.getId());
	}

	public MarkRevisedRequest()
	{
		super();
	}

	public boolean isRevised()
	{
		return revised;
	}

	public void setRevised(boolean revised)
	{
		this.revised = revised;
	}

	public static MarkRevisedRequest revise(EntityReferenceData ref)
	{
		MarkRevisedRequest req = new MarkRevisedRequest(ref);
		req.setRevised(true);
		return req;
	}

	public static MarkRevisedRequest unrevise(EntityReferenceData ref)
	{
		MarkRevisedRequest req = new MarkRevisedRequest(ref);
		req.setRevised(false);
		return req;
	}

	public static MarkRevisedRequest create(String entityType, String id, boolean revised)
	{
		MarkRevisedRequest req = new MarkRevisedRequest();
		req.setEntityType(entityType);
		req.setId(id);
		req.setRevised(revised);
		return req;
	}
}
