package com.namasoft.contracts.common.dtos.requests;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.layout.Owner;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PreferencesRequest extends ServiceRequest
{
	public static final String META_DATA = "metaData";
	public static final String EDIT_LAYOUT = "editLayout";
	public static final String LIST_LAYOUT = "listLayout";
	public static final String SEARCHER_LAYOUT = "searcherLayout";
	public static final String VIEW_NAMES = "viewNames";
	public static final String LIST_LAYOUT_PREFERENCES = "listLayoutPreferences";
	private Owner owner;
	private List<String> properties;

	public PreferencesRequest()
	{
		super();
	}

	public PreferencesRequest(Owner owner, List<String> properties)
	{
		setOwner(owner);
		setProperties(new ArrayList<String>(properties));
	}

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public List<String> getProperties()
	{
		return properties;
	}

	public void setProperties(List<String> properties)
	{
		this.properties = properties;
	}

}
