package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PutRequest<T> extends ServiceRequest
{
	private T value;
	private boolean override;

	public T getValue()
	{
		return value;
	}

	public void setValue(T value)
	{
		this.value = value;
	}

	public PutRequest(T value)
	{
		this(value, false);
	}

	public PutRequest(T value, boolean override)
	{
		this();
		setValue(value);
		setOverride(override);
	}

	public PutRequest()
	{
		super();
	}

	public boolean isOverride()
	{
		return override;
	}

	public void setOverride(boolean override)
	{
		this.override = override;
	}

}
