package com.namasoft.contracts.common.dtos.requests;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.DTOConfirmation;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class RequestCommitRequest extends EntityOperationRequest implements ExportableRequest
{
	private static final long serialVersionUID = -6343270242784236013L;
	private boolean importing = false;
	private boolean skipExporting = false;
	private String importType;
	private List<DTOConfirmation> confirmations;

	public RequestCommitRequest()
	{
	}

	public RequestCommitRequest(EntityReferenceData entity)
	{
		super(entity);
	}

	public RequestCommitRequest(String entityType, String id, String code)
	{
		super(entityType, id, code);
	}

	@Override
	public boolean isImporting()
	{
		return importing;
	}

	public void setImporting(boolean importing)
	{
		this.importing = importing;
	}

	@Override
	public boolean isSkipExporting()
	{
		return skipExporting;
	}

	public void setSkipExporting(boolean skipExporting)
	{
		this.skipExporting = skipExporting;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

	public String getImportType()
	{
		return importType;
	}

	public void setImportType(String importType)
	{
		this.importType = importType;
	}
}