package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ResetPasswordRequest extends ServiceRequest
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String loginId;
	private String email;
	private String phoneNumber;
	private Boolean sendSMS;
	private Boolean sendEmail;

	public ResetPasswordRequest()
	{
		super();
	}

	public ResetPasswordRequest(String loginId, String email, String phoneNumber, Boolean sendEmail, Boolean sendSMS)
	{
		super();
		this.loginId = loginId;
		this.email = email;
		this.sendSMS = sendSMS;
		this.phoneNumber = phoneNumber;
		this.sendEmail = sendEmail;
	}

	public String getLoginId()
	{
		return loginId;
	}

	public void setLoginId(String loginId)
	{
		this.loginId = loginId;
	}

	public String getEmail()
	{
		return email;
	}

	public void setEmail(String email)
	{
		this.email = email;
	}

	public Boolean getSendSMS()
	{
		return sendSMS;
	}

	public void setSendSMS(Boolean sendSMS)
	{
		this.sendSMS = sendSMS;
	}

	public Boolean getSendEmail()
	{
		return sendEmail;
	}

	public void setSendEmail(Boolean sendEmail)
	{
		this.sendEmail = sendEmail;
	}

	public String getPhoneNumber()
	{
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber)
	{
		this.phoneNumber = phoneNumber;
	}
}
