package com.namasoft.contracts.common.dtos.requests;

import java.util.HashMap;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.layout.metadata.FieldTooltipInfo;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class RunTooltipReq extends NaMaDTO
{
	private String targetEntityType;
	private List<FieldTooltipInfo> tooltipInfo;
	private HashMap<String, String> parameters;

	public RunTooltipReq()
	{
	}

	public RunTooltipReq(String targetEntityType, List<FieldTooltipInfo> tooltipInfo, HashMap<String, String> parameters)
	{
		this();
		this.targetEntityType = targetEntityType;
		this.tooltipInfo = tooltipInfo;
		this.parameters = parameters;
	}

	public String getTargetEntityType()
	{
		return targetEntityType;
	}

	public void setTargetEntityType(String targetEntityType)
	{
		this.targetEntityType = targetEntityType;
	}

	public List<FieldTooltipInfo> getTooltipInfo()
	{
		return tooltipInfo;
	}

	public void setTooltipInfo(List<FieldTooltipInfo> tooltipInfo)
	{
		this.tooltipInfo = tooltipInfo;
	}

	public HashMap<String, String> getParameters()
	{
		return parameters;
	}

	public void setParameters(HashMap<String, String> parameters)
	{
		this.parameters = parameters;
	}

}
