package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.utilities.DTOConfirmation;
import jakarta.xml.bind.annotation.*;

import java.util.List;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class SaveDraftRequest<DTO> extends EntityServiceRequest implements ExportableRequest, HasDoNotRunSqlFieldsInFactories<SaveDraftRequest<DTO>>
{
	private static final long serialVersionUID = -3642217117747338963L;
	private DTO data;
	private boolean skipExporting = false;
	private boolean importing = false;
	private String importType;
	private List<DTOConfirmation> confirmations;
	private Boolean doNotRunSqlFieldsInFactories;

	public DTO getData()
	{
		return data;
	}

	public void setData(DTO data)
	{
		this.data = data;
	}

	public SaveDraftRequest(DTO data)
	{
		this.data = data;
	}

	public SaveDraftRequest()
	{
		super();
	}

	@Override
	public boolean isImporting()
	{
		return importing;
	}

	public void setImporting(boolean importing)
	{
		this.importing = importing;
	}

	public boolean isSkipExporting()
	{
		return skipExporting;
	}

	public void setSkipExporting(boolean skipExporting)
	{
		this.skipExporting = skipExporting;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

	public String getImportType()
	{
		return importType;
	}

	public void setImportType(String importType)
	{
		this.importType = importType;
	}

	public Boolean getDoNotRunSqlFieldsInFactories()
	{
		return doNotRunSqlFieldsInFactories;
	}

	public void setDoNotRunSqlFieldsInFactories(Boolean doNotRunSqlFieldsInFactories)
	{
		this.doNotRunSqlFieldsInFactories = doNotRunSqlFieldsInFactories;
	}

	@Override
	public Boolean fetchDoNotRunSqlFieldsInFactories()
	{
		return getDoNotRunSqlFieldsInFactories();
	}

	@Override
	public void updateDoNotRunSqlFieldsInFactories(Boolean doNotRunSqlFieldsInFactories)
	{
		setDoNotRunSqlFieldsInFactories(doNotRunSqlFieldsInFactories);
	}
}
