package com.namasoft.contracts.common.dtos.requests;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.contracts.common.dtos.DTOSearchResultSettings;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SearchRequest extends EntityServiceRequest implements Serializable
{
	private static final long serialVersionUID = 2070709193113508147L;
	private DTOCriteria criteria;
	private DTOSearchResultSettings searchResultSettings;
	private boolean asc = true;
	private boolean filterOnAllDimensions = false;

	public static SearchRequest createValueObjectSearchRequest(String dtoClassName, DTOCriteria criteria, List<String> columnsToGet, int recordsCount)
	{
		DTOSearchResultSettings searchSettings = new DTOSearchResultSettings();
		searchSettings.setColumnsToGet(columnsToGet);
		searchSettings.setPageData(DTOPageData.firstPage(recordsCount));
		criteria.setOwnerType(dtoClassName);
		return new SearchRequest(dtoClassName, criteria, searchSettings);
	}

	public static SearchRequest createValueObjectSearchRequest(Class<?> dtoClassName, DTOCriteria criteria, List<String> columnsToGet,
			int recordsCount)
	{
		return createValueObjectSearchRequest(dtoClassName.getName(), criteria, columnsToGet, recordsCount);
	}

	public SearchRequest()
	{
		super();
	}

	public SearchRequest(String entityType, DTOCriteria criteria, DTOSearchResultSettings searchResultSettings)
	{
		super(entityType);
		this.criteria = criteria;
		this.searchResultSettings = searchResultSettings;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public DTOSearchResultSettings getSearchResultSettings()
	{
		return searchResultSettings;
	}

	public void setSearchResultSettings(DTOSearchResultSettings searchResultSettings)
	{
		this.searchResultSettings = searchResultSettings;
	}

	public boolean isAsc()
	{
		return asc;
	}

	public void setAsc(boolean asc)
	{
		this.asc = asc;
	}

	public boolean isFilterOnAllDimensions()
	{
		return filterOnAllDimensions;
	}

	public void setFilterOnAllDimensions(boolean filterOnAllDimensions)
	{
		this.filterOnAllDimensions = filterOnAllDimensions;
	}

	public Integer calcPageSize()
	{
		if (getSearchResultSettings() == null || getSearchResultSettings().getPageData() == null)
			return null;
		return getSearchResultSettings().getPageData().getPageSize();
	}
}
