package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class SendListRequest<T> extends ServiceRequest
{
	private List<T> data;

	public SendListRequest(List<T> data)
	{
		this();
		setData(data);
	}

	public SendListRequest()
	{
		super();
	}

	public List<T> getData()
	{
		return data;
	}

	public void setData(List<T> data)
	{
		this.data = data;
	}

	public SendListRequest otherInfo(String otherInfo)
	{
		setOtherInfo(otherInfo);
		return this;
	}
}
