package com.namasoft.contracts.common.dtos.requests;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.criteria.DTOCriteria;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TabularRequest extends EntityServiceRequest implements IListOrTabularRequest
{
	private List<String> columns;
	private List<String> columnsToSearchIn = new ArrayList<String>();
	private String valueToSearch = "";
	private int startPage = -1;
	private int pageSize = -1;
	private String orderBy;
	private DTOCriteria criteria;
	private DTOCriteria extraCriteria;
	private Boolean asc;
	private String extraCriteriaId;
	private String searchInsideFieldId;
	private String searchInsideEntity;
	public TabularRequest()
	{
		super();
	}

	public TabularRequest(String entityType, String orderBy, List<String> columns)
	{
		super(entityType);
		this.columns = columns;
		this.orderBy = orderBy;
	}

	public TabularRequest(String entityType, String orderBy, List<String> columns, String valueToSearch, List<String> columnsToSearchIn,
			int startpage, int pageSize, DTOCriteria criteria)
	{
		this(entityType, orderBy, columns);
		this.valueToSearch = valueToSearch;
		this.columnsToSearchIn = columnsToSearchIn;
		this.pageSize = pageSize;
		this.startPage = startpage;
		this.criteria = criteria;
	}

	public TabularRequest(String entityType, String orderBy, List<String> columns, int startpage, int pageSize)
	{
		this(entityType, orderBy, columns);
		this.pageSize = pageSize;
		this.startPage = startpage;
	}

	public List<String> getColumns()
	{
		return columns;
	}

	public void setColumns(List<String> columns)
	{
		this.columns = columns;
	}

	public List<String> getColumnsToSearchIn()
	{
		return columnsToSearchIn;
	}

	public void setColumnsToSearchIn(List<String> columnsToSearchIn)
	{
		this.columnsToSearchIn = columnsToSearchIn;
	}

	public String getValueToSearch()
	{
		return valueToSearch;
	}

	public void setValueToSearch(String value)
	{
		this.valueToSearch = value;
	}

	public int getStartPage()
	{
		return startPage;
	}

	public void setStartPage(int startPage)
	{
		this.startPage = startPage;
	}

	public int getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
	}

	public String getOrderBy()
	{
		return orderBy;
	}

	public void setOrderBy(String orderBy)
	{
		this.orderBy = orderBy;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public DTOCriteria getExtraCriteria()
	{
		return extraCriteria;
	}

	public void setExtraCriteria(DTOCriteria extraCriteria)
	{
		this.extraCriteria = extraCriteria;
	}

	public Boolean getAsc()
	{
		return asc;
	}

	public void setAsc(Boolean asc)
	{
		this.asc = asc;
	}

	public void setExtraCriteriaId(String extraCriteriaId)
	{
		this.extraCriteriaId = extraCriteriaId;
	}

	public String getExtraCriteriaId()
	{
		return extraCriteriaId;
	}

	public TabularRequest criteria(DTOCriteria criteria)
	{
		setCriteria(criteria);
		return this;
	}

	public String getSearchInsideFieldId()
	{
		return searchInsideFieldId;
	}

	@Override
	public void setSearchInsideFieldId(String searchInsideFieldId)
	{
		this.searchInsideFieldId = searchInsideFieldId;
	}

	public String getSearchInsideEntity()
	{
		return searchInsideEntity;
	}

	@Override
	public void setSearchInsideEntity(String searchInsideEntity)
	{
		this.searchInsideEntity = searchInsideEntity;
	}
}
