package com.namasoft.contracts.common.dtos.results;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CreateNewResult<DTO> extends GetResult<DTO> implements Serializable
{
	private static final long serialVersionUID = -3935535311023247741L;
	private String focusField;

	public CreateNewResult()
	{
	}

	public CreateNewResult(ResultDTO result, DTO data, String focusField)
	{
		super(data, result);
		setFocusField(focusField);
	}

	public String getFocusField()
	{
		return focusField;
	}

	public void setFocusField(String focusField)
	{
		this.focusField = focusField;
	}

}