package com.namasoft.contracts.common.dtos.results;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSeeAlso;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.contracts.common.dtos.DTOLargeDataWithoutAttachment;
import com.namasoft.contracts.common.dtos.DocumentFileDTO;
import com.namasoft.contracts.common.dtos.MasterFileDTO;

@SuppressWarnings({ "unchecked" })
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ MasterFileDTO.class, DocumentFileDTO.class })
public class DTOTabularResult implements Serializable
{
	private static final long serialVersionUID = -4035711823036076755L;
	private HashMap<String, Object> values = new HashMap<String, Object>();
	private DateWrapper dummyDate;
	private DTOLargeDataWithoutAttachment dummyAttachment;

	public DTOTabularResult()
	{
	}

	public HashMap<String, Object> getValues()
	{
		return values;
	}

	public void setValues(HashMap<String, Object> values)
	{
		this.values = values;
	}

	public <T> T get(String key)
	{
		if (values == null)
			return null;
		return (T) values.get(key);
	}

	public String getStr(String key)
	{
		return get(key);
	}

	public void put(String key, Object value)
	{
		if (values == null)
			values = new HashMap<String, Object>();
		if (value instanceof Date)
			value = new DateWrapper((Date) value);
		values.put(key, value);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null || !(obj instanceof DTOTabularResult))
			return false;
		if (get("id") == null)
			return false;
		return get("id").toString().equals(((DTOTabularResult) obj).get("id"));
	}

	public DateWrapper getDummyDate()
	{
		return dummyDate;
	}

	public void setDummyDate(DateWrapper date)
	{
		this.dummyDate = date;
	}

	public DTOLargeDataWithoutAttachment getDummyAttachment()
	{
		return dummyAttachment;
	}

	public void setDummyAttachment(DTOLargeDataWithoutAttachment dummyAttachment)
	{
		this.dummyAttachment = dummyAttachment;
	}

	@Override
	public int hashCode()
	{
		Object id = get("id");
		return id == null ? super.hashCode() : id.hashCode();
	}

}
