package com.namasoft.contracts.common.dtos.results;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.layout.list.ListViewQuickFilterGroupVal;
import com.namasoft.common.layout.metadata.BasicFieldMetaData;
import com.namasoft.contracts.common.dtos.ListStyle;
import jakarta.xml.bind.annotation.*;

import java.util.List;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListEntityResultBase<T> extends PagedListResult<T>
{
	private ListStyle style;
	private List<BasicFieldMetaData> processedColumnsMetaData;
	private List<ListViewQuickFilterGroupVal> quickFilters;

	public ListEntityResultBase(Integer pageNumber, Integer pageSize, Long totalRecordsCount, String orderedBy, List<T> page, ResultDTO result,
			ListStyle style, List<BasicFieldMetaData> processedColumnsMetaData)
	{
		super(pageNumber, pageSize, totalRecordsCount, orderedBy, page, result);
		setStyle(style);
		setProcessedColumnsMetaData(processedColumnsMetaData);
	}

	public ListEntityResultBase()
	{
		super();
	}

	public ListEntityResultBase(ResultDTO result)
	{
		super(result);
	}

	public ListStyle getStyle()
	{
		return style;
	}

	public void setStyle(ListStyle style)
	{
		this.style = style;
	}

	public List<BasicFieldMetaData> getProcessedColumnsMetaData()
	{
		return processedColumnsMetaData;
	}

	public void setProcessedColumnsMetaData(List<BasicFieldMetaData> processedColumnsMetaData)
	{
		this.processedColumnsMetaData = processedColumnsMetaData;
	}

	public List<ListViewQuickFilterGroupVal> getQuickFilters()
	{
		return quickFilters;
	}

	public void setQuickFilters(List<ListViewQuickFilterGroupVal> quickFilters)
	{
		this.quickFilters = quickFilters;
	}
}
