package com.namasoft.contracts.common.dtos.results;

import com.namasoft.common.ResultDTO;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListResultWithTemplates<DTO> extends ListResult<DTO> implements Serializable
{
	private String arabicTemplate;
	private String englishTemplate;

	public ListResultWithTemplates()
	{
	}

	public ListResultWithTemplates(List<DTO> list)
	{
		super(list);
	}

	public ListResultWithTemplates(List<DTO> list, ResultDTO result)
	{
		super(list, result);
	}

	public String getArabicTemplate()
	{
		return arabicTemplate;
	}

	public void setArabicTemplate(String arabicTemplate)
	{
		this.arabicTemplate = arabicTemplate;
	}

	public String getEnglishTemplate()
	{
		return englishTemplate;
	}

	public void setEnglishTemplate(String englishTemplate)
	{
		this.englishTemplate = englishTemplate;
	}
}
