package com.namasoft.contracts.common.dtos.results;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.layout.metadata.BasicFieldMetaData;
import com.namasoft.contracts.common.dtos.*;
import jakarta.xml.bind.annotation.*;

import java.util.List;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ListTimelineResult extends ListEntityResultBase<DTOTimelineData>
{

	public ListTimelineResult(Integer pageNumber, Integer pageSize, Long totalRecordsCount, String orderedBy, List<DTOTimelineData> page,
			ResultDTO result, ListStyle format, List<BasicFieldMetaData> processedColumnsMetaData)
	{
		super(pageNumber, pageSize, totalRecordsCount, orderedBy, page, result, format, processedColumnsMetaData);
	}

	public ListTimelineResult(ListEntityResult parent, List<DTOTimelineData> page)
	{
		super(parent.getPageNumber(), parent.getPageSize(), parent.getTotalRecordsCount(), parent.getOrderedBy(), page, parent.getResult(), parent.getStyle(), parent.getProcessedColumnsMetaData());
	}

	public ListTimelineResult()
	{
		super();
	}

	public ListTimelineResult(ResultDTO result)
	{
		super(result);
	}

	@Override
	public List<DTOTimelineData> getPage()
	{
		return super.getPage();
	}

	@Override
	public void setPage(List<DTOTimelineData> page)
	{
		super.setPage(page);
	}
}
