package com.namasoft.contracts.common.dtos.results;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class PagedListResult<DTO> extends ServiceResponse implements Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -4218443400236858996L;
	private Integer pageNumber;
	private Integer pageSize;
	private Long totalRecordsCount;
	private String orderedBy;
	protected List<DTO> page;

	public PagedListResult()
	{
	}

	public PagedListResult(List<DTO> page, ResultDTO result)
	{
		this(null, null, null, null, page, result);
	}

	public PagedListResult(ResultDTO result)
	{
		this(null, null, null, null, null, result);
	}

	public PagedListResult(Integer pageNumber, Integer pageSize, Long totalRecordsCount, String orderedBy, List<DTO> page, ResultDTO result)
	{
		setResult(result);
		setPageNumber(pageNumber);
		setPageSize(pageSize);
		setOrderedBy(orderedBy);
		setPage(page);
		setTotalRecordsCount(totalRecordsCount);
	}

	public Integer getPageNumber()
	{
		return pageNumber;
	}

	public void setPageNumber(Integer from)
	{
		this.pageNumber = from;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer to)
	{
		this.pageSize = to;
	}

	public Long getTotalRecordsCount()
	{
		return totalRecordsCount;
	}

	public void setTotalRecordsCount(Long totalRecordsCount)
	{
		this.totalRecordsCount = totalRecordsCount;
	}

	public String getOrderedBy()
	{
		return orderedBy;
	}

	public void setOrderedBy(String orderBy)
	{
		this.orderedBy = orderBy;
	}

	public List<DTO> getPage()
	{
		return page;
	}

	public void setPage(List<DTO> page)
	{
		this.page = page;
	}

}
