package com.namasoft.contracts.common.services;

import com.namasoft.common.*;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.utils.MobileQrResponse;
import com.namasoft.contracts.common.DTOImportDataReq;
import com.namasoft.contracts.common.dtos.*;
import com.namasoft.contracts.common.dtos.config.valueobjects.DTOEntryDimensions;
import com.namasoft.contracts.common.dtos.exporting.ReadRecordImportConfigDataReq;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.contracts.common.services.base.NaMaUtilityWS;
import com.namasoft.modules.commonbasic.contracts.details.DTOTaxAuthoritySubmissionLine;
import com.namasoft.modules.commonbasic.contracts.entities.*;
import com.namasoft.modules.commonbasic.contracts.requests.DTOScreenModifierEditor;
import com.namasoft.modules.commonbasic.contracts.valueobjects.*;
import com.namasoft.taxauthority.TaxAuthorityDocument;
import jakarta.jws.*;

import java.io.IOException;

@WebService(name = "basicutilityws")
public interface BasicUtilityWS extends NaMaUtilityWS
{
	@WebMethod
	GetResult<DTOEntryDimensions> getDimensionsOf(@WebParam(name = "request") DimensionByCodeRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOGenericDimensions> getCurrentUserDimensions(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<CurrencyRateResult> getCurrencyRate(@WebParam(name = "request") CurrencyRateRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Integer> getCurrencyPrecision(@WebParam(name = "request") SendRequest<EntityReferenceData> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> getLegalEntityLocalCurrency(@WebParam(name = "request") SendRequest<EntityReferenceData> request) throws NaMaServiceExcepption;


	@WebMethod
	ListResult<String> fetchAllEntityActions(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> fetchActionClassDescription(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<NaMaText> suggestActionClassValues(@WebParam(name = "request") SendRequest<DTOEntityFlowSuggestValuesActionClassRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse generateReceiptPapers(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteOldReceiptPapersOf(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteSelectedTasks(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteExecutedTasks(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteSelectedNotifications(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteAllNotifications(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteCurrentUserReadNotifications(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteAllUsersReadNotifications(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteNotificationsUntilDate(@WebParam(name = "request") SendDateRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> suggestContextFields(@WebParam(name = "request") SendRequest<DTOSuggestGUIPostActionParams> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse regenAccEffect(@WebParam(name = "request") EntityOperationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse regenInventoryEffects(@WebParam(name = "request") EntityOperationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addToUserFavourite(@WebParam(name = "request") DTOUserFavouritesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse removeFromUserFavourite(@WebParam(name = "request") DTOUserFavouritesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOUserFavourites> findFavouritesOfCurrentUser(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addOrUpdateCRMTroubleTicketEntry(@WebParam(name = "request") SendRequest<DTOCRMTroubleTicketReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOCRMTroubleTicketReq> createCRMTroubleTicketFromProcessor(@WebParam(name = "request") SendRequest<DTOCRMTroubleTicketReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResultWithTemplates<DTOCRMTroubleTicketReq> checkCRMTroubleTicketStatusInNama(@WebParam(name = "request") SendListRequest<CRMTroubleTicketIdAndLastUpdated> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> listUserLevels(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addExportActionHistory(@WebParam(name = "request") SendRequest<EntityReferenceData> request)
			throws NaMaServiceExcepption;
	@WebMethod
	ServiceResponse reSendCRMTroubleTickets(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOCRMTroubleTicketReq> findCRMTroubleTicketEntry(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	MapResult<String, String> fetchMobileUserData(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	UserInfoResult fetchMobileUserInfo(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateFCMDeviceTokens(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse removeFCMMobileTokens(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOShoppingMobAppConfig> findApplicableShoppingMobAppConfig(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> fetchCurrentUserRelatedEntity(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse acceptDeviceIdentifierDocumentAndDisableOther(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse acceptDeviceIdentifierDocument(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse rejectDeviceIdentifierDocument(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse fetchAndSaveSystemHelps(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOSimpleEntityHelp> fetchSystemHelps(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<StringPair> listAutomaticFilterIds(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> listApprovalReasons(@WebParam(name = "request") ListPageMatchingRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse oAuthFileResponse(@WebParam(name = "request") SendRequest<StringPair> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getOAuthAuthorizationURL(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse initiateOAuth(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse revokeAuthentication(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> ml(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOCriteria> fetchMobileAppFieldCriteria(@WebParam(name = "request") SendRequest<FindMobileFieldCriteriaReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOPaymentMethod> calcMobileCustomerPaymentMethod(@WebParam(name = "request") SendRequest<FlatObject> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ReadAttachmentResult runSql(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> fetchTableAndColumnNames(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOTaxAuthoritySubmissionLine> collectTaxAuthorityDocs(@WebParam(name = "request") SendRequest<EInvoiceCollectDocsRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ResultDTO> sendTaxAuthDocs(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ResultDTO> sendNotSentTaxAuthDocuments(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<SuggestionProvidedItem> suggestTaxAuthCodes(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> parentTaxOfSubTax(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse validateTaxAuthorityDocs(@WebParam(name = "request") SendListRequest<DTOTaxAuthoritySubmissionLine> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EInvoiceSignResponse> validateTaxAuthorityDocsCalcAndGetJson(@WebParam(name = "request") SendRequest<EInvoiceSignReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<TaxAuthorityDocument> fetchTaxAuthorityDocs(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ResultDTO> checkDocumentsStatus(@WebParam(name = "request") SendListRequest<DTOTaxAuthoritySubmissionLine> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> signDocumentsSignatures(@WebParam(name = "request") SendRequest<EInvoiceSignReq> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> prepareEIvnoiceVisistorLink(@WebParam(name = "request") SendListRequest<ByIdRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> prepareEIvnoiceUserLink(@WebParam(name = "request") SendListRequest<ByIdRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> findLegalEntityCurrency(@WebParam(name = "request") SendRequest<EntityReferenceData> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateCustomerInfo(@WebParam(name = "request") SendRequest<EntityReferenceData> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateSupplierInfo(@WebParam(name = "request") SendRequest<EntityReferenceData> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addUser(@WebParam(name = "request") SendRequest<EntityReferenceData> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addUserReqFromUrl(@WebParam(name = "request") SendRequest<DTOUserAddReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<MobileAppUserSettings> fetchMobileAppUserSettings(@WebParam(name = "request") ServiceRequest serviceRequest)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> prepareApprovalRules(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> applicableEInvoiceDocIds(@WebParam(name = "request") SendRequest<EInvoiceCollectDocsRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse moveApprovalCasesToDelegatedEmployee(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse retrySelectedTasks(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse createDocumentsFromLines(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse decompressHeaderFileToDetails(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOSupplier> createSupplier(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse discardDraft(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse uploadOneTimeInvoiceToGoPay(@WebParam(name = "request") SendRequest<DTOGoPayRequestLine> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cancelInvoiceFromGoPay(@WebParam(name = "request") SendRequest<DTOGoPayRequestLine> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse uploadBulkInvoicesToGoPay(@WebParam(name = "request") SendRequest<DTOGoPayRequestLine> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse handelPaymentNotificationFromGoPay(@WebParam(name = "request") SendRequest<DTOGoPayPaymentRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse retryPaymentNotification(@WebParam(name = "request") SendRequest<DTOGoPayRequestLine> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOCustomer> createCustomer(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse linkEInvoiceWithNamaInvoice(@WebParam(name = "request") SendRequest<DTOTaxPayerConfiguration> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse handleEInvoiceNotification(@WebParam(name = "request") SendListRequest<DTOEInvoiceReceivedEventEntry> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse readEInvoiceNotificationsFromIntermediaryServer(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOEInvoiceReceivedEventEntry> listEInvoiceNotifications(
			@WebParam(name = "request") SendRequest<ListEInvoiceIntermediaryNotification> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cleanDatabase(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse retryDeletingSelectedFailedCleanDatabaseRecords(@WebParam(name = "request") SendListRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse retryDeletingFailedCleanDatabaseRecords(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateWhatsAppMessageStateEntry(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption, IOException;

	@WebMethod
	ServiceResponse updateWatiWhatsAppMessageStateEntry(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption, IOException;

	@WebMethod
	ServiceResponse updateRasayelWhatsAppMessageStateEntry(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption, IOException;

	@WebMethod
	ServiceResponse clearDatabaseFailureEntry(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cleanActionsHistory(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cleanEntityVersion(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse recalculateEInvoiceJsonFromTaxAuthSubmissionDoc(@WebParam(name = "request") SendListRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse recalculateEInvoiceJsonForSelectedLinesFromTaxAuthSubmissionDoc(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOLargeData> exportCurrentEInvoiceDataForSelectedLinesFromTaxAuthSubmissionDoc(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOLargeData> exportLastSentDataForSelectedLinesFromTaxAuthSubmissionDoc(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteSelectedSentEntries(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteExecutedSentEntries(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse activateEReceiptPOS(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse saveEditScreenLayoutInScreenModifier(@WebParam(name = "request") SendRequest<DTOScreenModifierEditor> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteUnusedScreenLayouts(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> renderPaymentDoc(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> createOnlinePaymentTransactionSysEntryAndCreateRedirectPaymentURL(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> renderExpiredTemplatePage(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> renderSuccessTemplatePage(@WebParam(name = "request") SendRequest<DTOHandlePaymentRequest> request) throws NaMaServiceExcepption;
	@WebMethod
	GetResult<String> prepareOnlinePaymentUrl(@WebParam(name = "request") SendRequest<DTOPreparePaymentURLRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOHandlePaymentResponse> handleOnlinePaymentResponseAndGetRenderedBodyTemplate(
			@WebParam(name = "request") SendRequest<DTOHandlePaymentRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> handleMyFatoorahOnlinePaymentCallback(@WebParam(name = "request") SendRequest<DTOMyFatoorahWebhookResponse> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTODefaultOnlinePaymentTemplatesResponse> calculateOnlinePaymentDefaultTemplates(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> fetchShipmentLocation(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse createMobileAppErrorLog(@WebParam(name = "request") SendRequest<MobileAppErrorLogReq> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse activateMultiEReceiptPOS(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse zatcaApproveSystem(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse recalculateRelatedEInvoiceDocs(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetTaxAuthorityCodesCache(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateFieldsMaxLengthInDB(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse runPurge(@WebParam SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateRequestStatus(@WebParam SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse generateCertificateAndKeys(@WebParam SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<NaMaError> startImportFromFilesConfig(@WebParam SendRequest<ReadRecordImportConfigDataReq> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<NamaExcelWorkBook> fetchWorkbooks(@WebParam SendRequest<DTOImportDataReq> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<FlatObject> collectDocumentsForCreatingPaymentLinks(@WebParam SendRequest<DTOCollectPaymentDocsRequest> sendRequest)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse createPaymentLinksForAggregatedDoc(@WebParam SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> fetchDocumentSubsidiarySourceFieldValue(@WebParam SendRequest<DTOFindFieldValueRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> checkIfServiceCenterModuleAvailable(@WebParam ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<PagedDTOTabularResult> fetchDistinctValues(@WebParam(name = "request") SendRequest<DistinctValuesRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<MobileQrResponse> executeMobileQRIntegrator(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse deleteSelectedEntityFlows(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOBulkEditField> fetchBulkEditFields(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

}