package com.namasoft.contracts.common.services;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.contracts.common.services.base.EntityService;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;

@WebService(name = "unifiedentityws")
public interface UnifiedEntityWS extends EntityService<BaseEntityDTO, EntityReferenceData>
{
	@Override
	@WebMethod
	CreateNewResult<BaseEntityDTO> createNew(@WebParam(name = "serviceRequest") CreateNewRequest serviceRequest) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	CreateNewResult<BaseEntityDTO> duplicate(@WebParam(name = "duplicateRequest") ByIdRequest duplicateRequest) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	SaveDraftResult<BaseEntityDTO> saveDraft(@WebParam(name = "saveDraftRequest") SaveDraftRequest<BaseEntityDTO> saveDraftRequest)
			throws NaMaServiceExcepption;

	@Override
	@WebMethod
	RequestCommitResult<BaseEntityDTO> saveAndCommit(@WebParam(name = "saveAndCommitRequest") SaveDraftRequest<BaseEntityDTO> saveAndCommitRequest)
			throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<BaseEntityDTO> findByID(@WebParam(name = "id") FindByIDRequest id) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<BaseEntityDTO> findByBusinessCode(@WebParam(name = "code") FindByBusinessCodeRequest code) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	RequestCommitResult<BaseEntityDTO> requestCommit(@WebParam(name = "rquestCommit") RequestCommitRequest rquestCommit) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	ListResult<BaseEntityDTO> listPageMatching(@WebParam(name = "request") ListPageMatchingRequest serviceRequest) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<BaseEntityDTO> navigate(@WebParam(name = "currentRecord") NavigationRequest request) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<EntityReferenceData> findRefByBusinessCode(@WebParam(name = "findRefRequest") ByCodeRequest findRefRequest)
			throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<EntityReferenceData> findRefById(@WebParam(name = "findRefByIdRequest") ByIdRequest findRefByIdRequest) throws NaMaServiceExcepption;

	@Override
	@WebMethod
	ListResult<EntityReferenceData> listPageMatchingRef(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest)
			throws NaMaServiceExcepption;
}