package com.namasoft.contracts.common.services.base;

import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.contracts.common.dtos.PagedDTOTabularResult;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.infra.contractsbase.common.approval.DTOApprovalCase;
import jakarta.jws.*;

/**
 * @author Qasid Any new operation that involves genetics should be overridden
 *         with the concrete class in implementor
 * @param <DTO>
 */
public interface EntityService<DTO, RefDTO>
{
	CreateNewResult<DTO> createNew(@WebParam(name = "serviceRequest") CreateNewRequest serviceRequest) throws NaMaServiceExcepption;

	CreateNewResult<DTO> duplicate(@WebParam(name = "duplicateRequest") ByIdRequest duplicateRequest) throws NaMaServiceExcepption;

	SaveDraftResult<DTO> saveDraft(@WebParam(name = "saveDraftRequest") SaveDraftRequest<DTO> saveDraftRequest) throws NaMaServiceExcepption;

	RequestCommitResult<DTO> saveAndCommit(@WebParam(name = "saveAndCommitRequest") SaveDraftRequest<DTO> saveAndCommitRequest)
			throws NaMaServiceExcepption;

	GetResult<DTO> findByID(@WebParam(name = "id") FindByIDRequest id) throws NaMaServiceExcepption;

	GetResult<DTO> findByBusinessCode(@WebParam(name = "code") FindByBusinessCodeRequest code) throws NaMaServiceExcepption;

	ListResult<DTO> listPageMatching(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<FlatObject> listPageMatchingFlat(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest)
			throws NaMaServiceExcepption;

	ListResult<RefDTO> listPageMatchingRef(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest) throws NaMaServiceExcepption;

	RequestCommitResult<DTO> requestCommit(@WebParam(name = "rquestCommit") RequestCommitRequest rquestCommit) throws NaMaServiceExcepption;

	GetResult<RefDTO> findRefByBusinessCode(@WebParam(name = "findRefRequest") ByCodeRequest findRefRequest) throws NaMaServiceExcepption;

	GetResult<RefDTO> findRefById(ByIdRequest findRefByIdRequest) throws NaMaServiceExcepption;

	@WebMethod
	DeleteResult delete(@WebParam(name = "id") EntityOperationRequest id) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Long> count(@WebParam(name = "serviceRequest") EntityServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	PagedDTOTabularResult tabularListPage(@WebParam(name = "request") TabularRequest request) throws NaMaServiceExcepption;

	GetResult<DTO> navigate(@WebParam(name = "currentRecord") NavigationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Long> getCurrentRecordOrderInList(@WebParam(name = "currentRecord") NavigationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	PagedDTOTabularResult search(@WebParam(name = "request") SearchRequest request) throws NaMaServiceExcepption;

	@WebMethod
	String getServiceEntityType() throws NaMaServiceExcepption;

	@WebMethod
	ListEntityResult list(@WebParam(name = "request") ListRequest request) throws NaMaServiceExcepption;

	@WebMethod
	FlatListEntityResult listFlat(@WebParam(name = "request") ListRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListTimelineResult listForTimeline(@WebParam(name = "request") ListRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOApprovalCase> getApprovalHistory(@WebParam(name = "request") GetApprovalRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOApprovalCase> approve(@WebParam(name = "request") ApproveRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOApprovalCase> approveFromURL(@WebParam(name = "request") SendRequest<DTOApproveFromURL> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> shouldShowCommentBoxForApprovalURL(@WebParam(name = "request") SendRequest<DTOApproveFromURL> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOApprovalCase> getCurrentApprovalCase(@WebParam(name = "request") GetApprovalRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse reReplicate(@WebParam(name = "id") EntityOperationRequest id) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse reCommit(@WebParam(name = "id") EntityOperationRequest id) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse markRevised(@WebParam(name = "id") MarkRevisedRequest id) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse restoreDeletedRecord(@WebParam(name = "id") FindByIDRequest id) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse changeCapability(@WebParam(name = "request") ChangeCapabilitiesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Long> countRecordsMatching(@WebParam(name = "request") ListPageMatchingRequest request) throws NaMaServiceExcepption;

}
