package com.namasoft.contracts.common.services.base;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.contracts.common.dtos.requests.ByCodeRequest;
import com.namasoft.contracts.common.dtos.requests.ByIdRequest;
import com.namasoft.contracts.common.dtos.requests.ListPageMatchingRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.common.exceptions.NaMaServiceExcepption;

public interface MasterEntityService<DTO extends MasterFileDTO> extends EntityService<DTO, EntityReferenceData>
{
	@Override
	@WebMethod
	GetResult<EntityReferenceData> findRefByBusinessCode(@WebParam(name = "findRefRequest") ByCodeRequest findRefRequest)
			throws NaMaServiceExcepption;

	@Override
	@WebMethod
	GetResult<EntityReferenceData> findRefById(@WebParam(name = "findRefByIdRequest") ByIdRequest findRefByIdRequest)
			throws NaMaServiceExcepption;

	@Override
	@WebMethod
	ListResult<EntityReferenceData> listPageMatchingRef(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest) throws NaMaServiceExcepption;

}
