package com.namasoft.contracts.util;

import com.namasoft.common.constants.ApplicationVersion;

public class DefaultApplicationInfo implements GUIApplicationInfo
{
	@Override
	public String getClientId()
	{
		return "test.gui.gwt";
	}

	@Override
	public String getExpectedServerVersion()
	{
		return ApplicationVersion.SERVER_VERSION + "";
	}

	@Override
	public String getApplicationVersion()
	{
		return ApplicationVersion.SERVER_VERSION + "." + ApplicationVersion.DATABASE_VERSION;
	}

	@Override
	public String getBuildDate()
	{
		return ApplicationVersion.BUILD_YEAR + "-" + lpad(ApplicationVersion.BUILD_MONTH) + "-" + lpad(ApplicationVersion.BUILD_DAY) + " " + lpad(
				ApplicationVersion.BUILD_HOUR) + ":" + lpad(ApplicationVersion.BUILD_MINUTE);
	}

	@Override
	public String getApplicationFullVersion()
	{
		return staticAppVersion();
	}

	public static String staticAppVersion()
	{
		return ApplicationVersion.SERVER_VERSION + "." + ApplicationVersion.DATABASE_VERSION + "."
				+ lpad(ApplicationVersion.BUILD_YEAR % 100, ApplicationVersion.BUILD_MONTH, ApplicationVersion.BUILD_DAY) + "."
				+ lpad(ApplicationVersion.BUILD_HOUR, ApplicationVersion.BUILD_MINUTE);
	}

	private  static String lpad(int... parts)
	{
		String txt = "";
		for (int part : parts)
		{
			if (part > 1999)
				part = part - 2000;
			if (part < 10)
				txt += "0" + part;
			else
				txt += part;
		}
		return txt;
	}
}
