package com.namasoft.infra.contractsbase.common.approval;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOApprovalCase extends DTOLocalEntity implements Serializable
{
	private Boolean allowModifyWhileUnderApproval;
	private Date completionDate;
	private Date nearestAutoEscalateDate;
	private EntityReferenceData analysisSet;
	private EntityReferenceData approvalDefinition;
	private EntityReferenceData approvalRef1;
	private EntityReferenceData approvalRef2;
	private EntityReferenceData approvedElement;
	private EntityReferenceData branch;
	private EntityReferenceData department;
	private EntityReferenceData legalEntity;
	private EntityReferenceData requestedBy;
	private EntityReferenceData sector;
	private Integer approvedVersion;
	private List<DTOApprovalCaseStep> steps = new ArrayList<DTOApprovalCaseStep>();
	private List<DTOApprovalCaseStepCandidate> nextCandidates = new ArrayList<DTOApprovalCaseStepCandidate>();
	private Long nextStepSequence;
	private Long secret;
	private String allowEditingFields;
	private String concernedLines;
	private String currentCandidates;
	private String currentLines;
	private String endOfCycleAction;
	private String initiator;
	private String moduleId;
	private String nextRequiredStatus;
	private String nextStepId;
	private String nextStepName1;
	private String nextStepName2;
	private String nextStepResponsible;
	private String nextUpdatedFields;
	private String state;
	private String summary;
	public Boolean getAllowModifyWhileUnderApproval()
	{
		return allowModifyWhileUnderApproval;
	}

	public Date getCompletionDate()
	{
		return completionDate;
	}

	public Date getNearestAutoEscalateDate()
	{
		return nearestAutoEscalateDate;
	}

	public EntityReferenceData getAnalysisSet()
	{
		return analysisSet;
	}

	public EntityReferenceData getApprovalDefinition()
	{
		return approvalDefinition;
	}

	public EntityReferenceData getApprovalRef1()
	{
		return approvalRef1;
	}

	public EntityReferenceData getApprovalRef2()
	{
		return approvalRef2;
	}

	public EntityReferenceData getApprovedElement()
	{
		return approvedElement;
	}

	public EntityReferenceData getBranch()
	{
		return branch;
	}

	public EntityReferenceData getDepartment()
	{
		return department;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public EntityReferenceData getRequestedBy()
	{
		return requestedBy;
	}

	public EntityReferenceData getSector()
	{
		return sector;
	}

	public Integer getApprovedVersion()
	{
		return approvedVersion;
	}

	public List<DTOApprovalCaseStep> getSteps()
	{
		return steps;
	}

	public List<DTOApprovalCaseStepCandidate> getNextCandidates()
	{
		return nextCandidates;
	}

	public Long getNextStepSequence()
	{
		return nextStepSequence;
	}

	public Long getSecret()
	{
		return secret;
	}

	public String getAllowEditingFields()
	{
		return allowEditingFields;
	}

	public String getConcernedLines()
	{
		return concernedLines;
	}

	public String getCurrentCandidates()
	{
		return currentCandidates;
	}

	public String getCurrentLines()
	{
		return currentLines;
	}

	public String getEndOfCycleAction()
	{
		return endOfCycleAction;
	}

	public String getInitiator()
	{
		return initiator;
	}

	public String getModuleId()
	{
		return moduleId;
	}

	public String getNextRequiredStatus()
	{
		return nextRequiredStatus;
	}

	public String getNextStepId()
	{
		return nextStepId;
	}

	public String getNextStepName1()
	{
		return nextStepName1;
	}

	public String getNextStepName2()
	{
		return nextStepName2;
	}

	public String getNextStepResponsible()
	{
		return nextStepResponsible;
	}

	public String getNextUpdatedFields()
	{
		return nextUpdatedFields;
	}

	public String getState()
	{
		return state;
	}

	public String getSummary()
	{
		return summary;
	}

	public void setAllowEditingFields(String allowEditingFields)
	{
		this.allowEditingFields = allowEditingFields;
	}

	public void setAllowModifyWhileUnderApproval(Boolean allowModifyWhileUnderApproval)
	{
		this.allowModifyWhileUnderApproval = allowModifyWhileUnderApproval;
	}

	public void setAnalysisSet(EntityReferenceData analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public void setApprovalDefinition(EntityReferenceData approvalDefinition)
	{
		this.approvalDefinition = approvalDefinition;
	}

	public void setApprovalRef1(EntityReferenceData approvalRef1)
	{
		this.approvalRef1 = approvalRef1;
	}

	public void setApprovalRef2(EntityReferenceData approvalRef2)
	{
		this.approvalRef2 = approvalRef2;
	}

	public void setApprovedElement(EntityReferenceData approvedElement)
	{
		this.approvedElement = approvedElement;
	}

	public void setApprovedVersion(Integer approvedVersion)
	{
		this.approvedVersion = approvedVersion;
	}

	public void setBranch(EntityReferenceData branch)
	{
		this.branch = branch;
	}

	public void setCompletionDate(Date completionDate)
	{
		this.completionDate = completionDate;
	}

	public void setConcernedLines(String concernedLines)
	{
		this.concernedLines = concernedLines;
	}

	public void setCurrentCandidates(String currentCandidates)
	{
		this.currentCandidates = currentCandidates;
	}

	public void setCurrentLines(String currentLines)
	{
		this.currentLines = currentLines;
	}

	public void setDepartment(EntityReferenceData department)
	{
		this.department = department;
	}

	public void setEndOfCycleAction(String endOfCycleAction)
	{
		this.endOfCycleAction = endOfCycleAction;
	}

	public void setInitiator(String initiator)
	{
		this.initiator = initiator;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public void setModuleId(String moduleId)
	{
		this.moduleId = moduleId;
	}

	public void setNearestAutoEscalateDate(Date nearestAutoEscalateDate)
	{
		this.nearestAutoEscalateDate = nearestAutoEscalateDate;
	}

	public void setNextCandidates(List<DTOApprovalCaseStepCandidate> nextCandidates)
	{
		this.nextCandidates = nextCandidates;
	}

	public void setNextRequiredStatus(String nextRequiredStatus)
	{
		this.nextRequiredStatus = nextRequiredStatus;
	}

	public void setNextStepId(String nextStepId)
	{
		this.nextStepId = nextStepId;
	}

	public void setNextStepName1(String nextStepName1)
	{
		this.nextStepName1 = nextStepName1;
	}

	public void setNextStepName2(String nextStepName2)
	{
		this.nextStepName2 = nextStepName2;
	}

	public void setNextStepResponsible(String nextStepResponsible)
	{
		this.nextStepResponsible = nextStepResponsible;
	}

	public void setNextStepSequence(Long nextStepSequence)
	{
		this.nextStepSequence = nextStepSequence;
	}

	public void setNextUpdatedFields(String nextUpdatedFields)
	{
		this.nextUpdatedFields = nextUpdatedFields;
	}

	public void setRequestedBy(EntityReferenceData requestedBy)
	{
		this.requestedBy = requestedBy;
	}

	public void setSecret(Long secret)
	{
		this.secret = secret;
	}

	public void setSector(EntityReferenceData sector)
	{
		this.sector = sector;
	}

	public void setState(String state)
	{
		this.state = state;
	}

	public void setSteps(List<DTOApprovalCaseStep> steps)
	{
		this.steps = steps;
	}

	public void setSummary(String summary)
	{
		this.summary = summary;
	}

}
