package com.namasoft.infra.contractsbase.common.approval;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTODetailLine;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOApprovalCaseStep extends DTODetailLine implements Serializable
{
	private Boolean escalated;
	private Boolean execution;
	private DTOLargeData attachment;
	private Date approvalDate;
	private EntityReferenceData actualResponsible;
	private EntityReferenceData approvalReason;
	private EntityReferenceData escalateTo;
	private EntityReferenceData escalatedFrom;
	private Long approvalStepSeq;
	private String approvalStepName1;
	private String approvalStepName2;
	private String comment;
	private String concernedLines;
	private String decision;
	private String requiredStatus;
	private String updatedFields;
	public Boolean getEscalated()
	{
		return escalated;
	}

	public Boolean getExecution()
	{
		return execution;
	}

	public DTOLargeData getAttachment()
	{
		return attachment;
	}

	public Date getApprovalDate()
	{
		return approvalDate;
	}

	public EntityReferenceData getActualResponsible()
	{
		return actualResponsible;
	}

	public EntityReferenceData getApprovalReason()
	{
		return approvalReason;
	}

	public EntityReferenceData getEscalateTo()
	{
		return escalateTo;
	}

	public EntityReferenceData getEscalatedFrom()
	{
		return escalatedFrom;
	}

	public Long getApprovalStepSeq()
	{
		return approvalStepSeq;
	}

	public String getApprovalStepName1()
	{
		return approvalStepName1;
	}

	public String getApprovalStepName2()
	{
		return approvalStepName2;
	}

	public String getComment()
	{
		return comment;
	}

	public String getConcernedLines()
	{
		return concernedLines;
	}

	public String getDecision()
	{
		return decision;
	}

	public String getRequiredStatus()
	{
		return requiredStatus;
	}

	public String getUpdatedFields()
	{
		return updatedFields;
	}

	public void setActualResponsible(EntityReferenceData actualResponsible)
	{
		this.actualResponsible = actualResponsible;
	}

	public void setApprovalDate(Date approvalDate)
	{
		this.approvalDate = approvalDate;
	}

	public void setApprovalReason(EntityReferenceData approvalReason)
	{
		this.approvalReason = approvalReason;
	}

	public void setApprovalStepName1(String approvalStepName1)
	{
		this.approvalStepName1 = approvalStepName1;
	}

	public void setApprovalStepName2(String approvalStepName2)
	{
		this.approvalStepName2 = approvalStepName2;
	}

	public void setApprovalStepSeq(Long approvalStepSeq)
	{
		this.approvalStepSeq = approvalStepSeq;
	}

	public void setAttachment(DTOLargeData attachment)
	{
		this.attachment = attachment;
	}

	public void setComment(String comment)
	{
		this.comment = comment;
	}

	public void setConcernedLines(String concernedLines)
	{
		this.concernedLines = concernedLines;
	}

	public void setDecision(String decision)
	{
		this.decision = decision;
	}

	public void setEscalateTo(EntityReferenceData escalateTo)
	{
		this.escalateTo = escalateTo;
	}

	public void setEscalated(Boolean escalated)
	{
		this.escalated = escalated;
	}

	public void setEscalatedFrom(EntityReferenceData escalatedFrom)
	{
		this.escalatedFrom = escalatedFrom;
	}

	public void setExecution(Boolean execution)
	{
		this.execution = execution;
	}

	public void setRequiredStatus(String requiredStatus)
	{
		this.requiredStatus = requiredStatus;
	}

	public void setUpdatedFields(String updatedFields)
	{
		this.updatedFields = updatedFields;
	}

}
