package com.namasoft.infra.contractsbase.common.approval;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTODetailLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOApprovalCaseStepCandidate extends DTODetailLine implements Serializable
{
	private Boolean escalated;
	private Date escalateOn;
	private Date requestedOn;
	private EntityReferenceData candidate;
	private EntityReferenceData escalatedFrom;
	private EntityReferenceData escalatedTo;
	private EntityReferenceData responsibility;
	private EntityReferenceData source;
	private String concernedLines;
	public Boolean getEscalated()
	{
		return escalated;
	}

	public Date getEscalateOn()
	{
		return escalateOn;
	}

	public Date getRequestedOn()
	{
		return requestedOn;
	}

	public EntityReferenceData getCandidate()
	{
		return candidate;
	}

	public EntityReferenceData getEscalatedFrom()
	{
		return escalatedFrom;
	}

	public EntityReferenceData getEscalatedTo()
	{
		return escalatedTo;
	}

	public EntityReferenceData getResponsibility()
	{
		return responsibility;
	}

	public EntityReferenceData getSource()
	{
		return source;
	}

	public String getConcernedLines()
	{
		return concernedLines;
	}

	public void setCandidate(EntityReferenceData candidate)
	{
		this.candidate = candidate;
	}

	public void setConcernedLines(String concernedLines)
	{
		this.concernedLines = concernedLines;
	}

	public void setEscalateOn(Date escalateOn)
	{
		this.escalateOn = escalateOn;
	}

	public void setEscalated(Boolean escalated)
	{
		this.escalated = escalated;
	}

	public void setEscalatedFrom(EntityReferenceData escalatedFrom)
	{
		this.escalatedFrom = escalatedFrom;
	}

	public void setEscalatedTo(EntityReferenceData escalatedTo)
	{
		this.escalatedTo = escalatedTo;
	}

	public void setRequestedOn(Date requestedOn)
	{
		this.requestedOn = requestedOn;
	}

	public void setResponsibility(EntityReferenceData responsibility)
	{
		this.responsibility = responsibility;
	}

	public void setSource(EntityReferenceData source)
	{
		this.source = source;
	}

}
