package com.namasoft.modules.commonbasic.contracts.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTODetailLineWithAdditional;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOAbsCreditLimits extends DTODetailLineWithAdditional implements Serializable
{
	private BigDecimal currentValue;
	private BigDecimal limitValue;
	private Boolean forbidBilling;
	private Boolean forbidOrdering;
	private EntityReferenceData analysisSet;
	private EntityReferenceData branch;
	private EntityReferenceData currency;
	private EntityReferenceData department;
	private EntityReferenceData legalEntity;
	private EntityReferenceData sector;
	private Integer creditPeriod;
	private Integer paymentPeriod;
	public BigDecimal getCurrentValue()
	{
		return currentValue;
	}

	public BigDecimal getLimitValue()
	{
		return limitValue;
	}

	public Boolean getForbidBilling()
	{
		return forbidBilling;
	}

	public Boolean getForbidOrdering()
	{
		return forbidOrdering;
	}

	public EntityReferenceData getAnalysisSet()
	{
		return analysisSet;
	}

	public EntityReferenceData getBranch()
	{
		return branch;
	}

	public EntityReferenceData getCurrency()
	{
		return currency;
	}

	public EntityReferenceData getDepartment()
	{
		return department;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public EntityReferenceData getSector()
	{
		return sector;
	}

	public Integer getCreditPeriod()
	{
		return creditPeriod;
	}

	public Integer getPaymentPeriod()
	{
		return paymentPeriod;
	}

	public void setAnalysisSet(EntityReferenceData analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public void setBranch(EntityReferenceData branch)
	{
		this.branch = branch;
	}

	public void setCreditPeriod(Integer creditPeriod)
	{
		this.creditPeriod = creditPeriod;
	}

	public void setCurrency(EntityReferenceData currency)
	{
		this.currency = currency;
	}

	public void setCurrentValue(BigDecimal currentValue)
	{
		this.currentValue = currentValue;
	}

	public void setDepartment(EntityReferenceData department)
	{
		this.department = department;
	}

	public void setForbidBilling(Boolean forbidBilling)
	{
		this.forbidBilling = forbidBilling;
	}

	public void setForbidOrdering(Boolean forbidOrdering)
	{
		this.forbidOrdering = forbidOrdering;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public void setLimitValue(BigDecimal limitValue)
	{
		this.limitValue = limitValue;
	}

	public void setPaymentPeriod(Integer paymentPeriod)
	{
		this.paymentPeriod = paymentPeriod;
	}

	public void setSector(EntityReferenceData sector)
	{
		this.sector = sector;
	}

}
